package com.instabug.bug.extendedbugreport;

import static com.instabug.bug.extendedbugreport.ExtendedBugReport.State.ENABLED_WITH_REQUIRED_FIELDS;

import android.content.Context;

import androidx.annotation.Nullable;

import com.instabug.bug.R;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StringUtility;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Created by tarek on 2/2/18.
 */

public class ExtendedBugReport {

    private static final String ID_REPRO_STEPS = "repro_steps";
    private static final String ID_ACTUAL_RESULT = "actual_result";
    private static final String ID_EXPECTED_RESULT = "expected_result";

    public static List<ExtraReportField> getFields(Context context, State state) {

        if (state == ENABLED_WITH_REQUIRED_FIELDS) {
            return getFields(context, true);
        } else {
            return getFields(context, false);
        }
    }

    private static List<ExtraReportField> getFields(Context context, boolean required) {

        List<ExtraReportField> extraReportFields = new ArrayList<>();
        String customHint;

        // 1. Steps to reproduce field configuration
        customHint = validateAndGetCustomHint(BugSettings.getInstance().getExtendedBugReportHint1());
        ExtraReportField stepsToReproduceReportField = new ExtraReportField(
                (customHint != null) ? customHint : LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context), R.string.instabug_str_steps_to_reproduce, context),
                (customHint != null) ? customHint : LocaleUtils.getLocaleStringResource(Locale.ENGLISH, R.string.instabug_str_steps_to_reproduce, context),
                required,
                ID_REPRO_STEPS);
        stepsToReproduceReportField.setFieldAccessibilityContentDescription((customHint != null) ? customHint : context.getString(R.string.ibg_extended_report_steps_to_reproduce_edit_text_description));
        extraReportFields.add(stepsToReproduceReportField);

        // 2. Actual results field configuration
        customHint = validateAndGetCustomHint(BugSettings.getInstance().getExtendedBugReportHint2());
        ExtraReportField actualResultsReportField = new ExtraReportField(
                (customHint != null) ? customHint : LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context), R.string.instabug_str_actual_results, context),
                (customHint != null) ? customHint : LocaleUtils.getLocaleStringResource(Locale.ENGLISH, R.string.instabug_str_actual_results, context),
                required,
                ID_ACTUAL_RESULT);
        actualResultsReportField.setFieldAccessibilityContentDescription((customHint != null) ? customHint : context.getString(R.string.ibg_extended_report_actual_results_edit_text_description));
        extraReportFields.add(actualResultsReportField);

        // 3. Expected results field configuration
        customHint = validateAndGetCustomHint(BugSettings.getInstance().getExtendedBugReportHint3());
        ExtraReportField expectedResultsReportField = new ExtraReportField(
                (customHint != null) ? customHint : LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context), R.string.instabug_str_expected_results, context),
                (customHint != null) ? customHint : LocaleUtils.getLocaleStringResource(Locale.ENGLISH, R.string.instabug_str_expected_results, context),
                required,
                ID_EXPECTED_RESULT);
        expectedResultsReportField.setFieldAccessibilityContentDescription((customHint != null) ? customHint : context.getString(R.string.ibg_extended_report_expected_results_edit_text_description));
        extraReportFields.add(expectedResultsReportField);
        return extraReportFields;
    }

    @Nullable
    private static String validateAndGetCustomHint(@Nullable String currentCustomHint) {
        if (!StringUtility.isNullOrEmpty(currentCustomHint)) {
            return currentCustomHint;
        }
        return null;
    }

    public enum State {
        DISABLED,
        ENABLED_WITH_REQUIRED_FIELDS,
        ENABLED_WITH_OPTIONAL_FIELDS
    }
}
