/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chats;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.Nullable;
import com.instabug.bug.R;
import com.instabug.chat.model.Chat;
import com.instabug.chat.ui.ChatActivity;
import com.instabug.chat.ui.base.ToolbarFragment;
import com.instabug.chat.ui.chats.ChatsAdapter;
import com.instabug.chat.ui.chats.ChatsContract$Presenter;
import com.instabug.chat.ui.chats.ChatsContract$View;
import com.instabug.chat.ui.chats.ChatsPresenter;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.PlaceHolderUtils;
import java.util.ArrayList;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class ChatsFragment
extends ToolbarFragment<ChatsContract$Presenter>
implements ChatsContract$View,
AdapterView.OnItemClickListener {
    private ChatsAdapter chatsAdapter;
    private ArrayList<Chat> chats;
    private Callbacks callbacks;

    public static ChatsFragment newInstance(boolean bl) {
        Bundle bundle;
        ChatsFragment chatsFragment = new ChatsFragment();
        Bundle bundle2 = bundle;
        new Bundle().putBoolean("compose_key", bl);
        chatsFragment.setArguments(bundle2);
        return chatsFragment;
    }

    public void onCreate(@Nullable Bundle object) {
        ArrayList arrayList;
        ChatsPresenter chatsPresenter;
        ChatsFragment chatsFragment = arrayList2;
        super.onCreate(object);
        chatsFragment.setRetainInstance(true);
        if (chatsFragment.getActivity() != null && arrayList2.getActivity() instanceof ChatActivity) {
            ((ChatsFragment)((Object)arrayList2)).callbacks = (Callbacks)arrayList2.getActivity();
        }
        ChatsFragment chatsFragment2 = arrayList2;
        object = chatsPresenter;
        chatsPresenter = new ChatsPresenter((ChatsContract$View)((Object)arrayList2));
        chatsFragment2.presenter = object;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        chatsFragment2.chats = arrayList2;
    }

    @Override
    protected int getContentLayout() {
        return R.layout.instabug_fragment_chats;
    }

    @Override
    protected void initContentViews(View view, @Nullable Bundle object) {
        object = (ImageButton)view.findViewById(R.id.instabug_btn_toolbar_right);
        if (object != null) {
            object.setVisibility(8);
        }
        if ((object = (ListView)view.findViewById(R.id.instabug_lst_chats)) != null) {
            ChatsAdapter chatsAdapter;
            Bundle bundle = object;
            object.setOnItemClickListener((AdapterView.OnItemClickListener)this);
            object = chatsAdapter;
            ChatsFragment chatsFragment = this;
            ArrayList<Chat> arrayList = chatsFragment.chats;
            chatsAdapter = new ChatsAdapter(arrayList, chatsFragment.getIBGTheme());
            this.chatsAdapter = object;
            bundle.setAdapter((ListAdapter)object);
        }
        if ((view = (ImageButton)view.findViewById(R.id.instabug_btn_toolbar_left)) != null) {
            view.setTag(R.id.TAG_BTN_CLOSE, (Object)"instabug_btn_close");
            view.setContentDescription((CharSequence)this.getLocalizedString(R.string.ibg_chats_conversations_close_content_description));
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.CONVERSATIONS_LIST_TITLE, (String)this.getLocalizedString(R.string.instabug_str_conversations));
    }

    @Override
    protected void onDoneButtonClicked() {
    }

    public void onStart() {
        ChatsFragment chatsFragment = this;
        super.onStart();
        BaseContract.Presenter presenter = chatsFragment.presenter;
        if (presenter != null) {
            ((ChatsContract$Presenter)presenter).start();
        }
        if (AccessibilityUtils.isTalkbackEnabled() && Build.VERSION.SDK_INT >= 16) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                if (this.getView() != null) {
                    this.getView().announceForAccessibility((CharSequence)this.getLocalizedString(R.string.ibg_chats_conversations_screen_content_description));
                }
            }, 300L);
        }
    }

    public void onStop() {
        ChatsFragment chatsFragment = chatsFragment2;
        super.onStop();
        ChatsFragment chatsFragment2 = chatsFragment.presenter;
        if (chatsFragment2 != null) {
            ((ChatsContract$Presenter)((Object)chatsFragment2)).stop();
        }
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        Callbacks callbacks = ((ChatsFragment)((Object)callbacks)).callbacks;
        if (callbacks != null) {
            callbacks.openChat(((Chat)adapterView.getItemAtPosition(n)).getId());
        }
    }

    @Override
    public void updateChats(ArrayList<Chat> arrayList) {
        this.chats = arrayList;
    }

    @Override
    public void showChats() {
        ChatsFragment chatsFragment = this;
        chatsFragment.chatsAdapter.setChats(this.chats);
        chatsFragment.chatsAdapter.notifyDataSetChanged();
    }

    @Override
    public boolean isChatsFragmentVisible() {
        if (this.getFragmentManager() != null) {
            return this.getFragmentManager().findFragmentById(R.id.instabug_fragment_container) instanceof ChatsFragment;
        }
        return false;
    }

    public static interface Callbacks {
        public void openChat(String var1);
    }
}

