/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.synchronization;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.chat.RepliesWrapper;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.cache.ReadQueueCacheManager;
import com.instabug.chat.eventbus.ChatTimeUpdatedEventBus;
import com.instabug.chat.model.ReadMessage;
import com.instabug.chat.network.service.MessagingService;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.synchronization.NewMessagesHandler;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.eventbus.eventpublisher.Subscriber;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.functions.Consumer;
import java.lang.ref.WeakReference;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
public class SynchronizationManager {
    private static volatile SynchronizationManager INSTANCE;
    @Nullable
    private Handler handler;
    @Nullable
    private SyncRunnable syncRunnable;
    @Nullable
    private IBGDisposable chatTimeSubscriber;
    private boolean shouldSync;
    private boolean isSyncing;
    private Consumer<Long> syncAction;
    private final Subscriber<Long> chattingTimeUpdateAction;

    public void sync(boolean bl) {
        Handler handler;
        if (bl) {
            this.resetTTL();
        }
        if ((handler = this.handler) != null && this.syncRunnable != null) {
            if (RepliesWrapper.isMessagingServiceAvailable() && !this.isSyncing()) {
                SynchronizationManager synchronizationManager = this;
                synchronizationManager.stop();
                synchronizationManager.shouldSync = true;
                handler.post((Runnable)synchronizationManager.syncRunnable);
            }
            this.handler = handler;
            return;
        }
    }

    public void stop() {
        ((SynchronizationManager)this).shouldSync = false;
        Handler handler = ((SynchronizationManager)this).handler;
        if (handler != null && (this = ((SynchronizationManager)this).syncRunnable) != null) {
            handler.removeCallbacks((Runnable)this);
        }
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public void release() {
        SynchronizationManager synchronizationManager = this;
        synchronizationManager.stop();
        synchronizationManager.unSubscribeToChatTimeUpdatedEvents();
        synchronizationManager.handler = null;
        synchronizationManager.syncRunnable = null;
        SynchronizationManager.tearDown();
    }

    private SynchronizationManager(final Context context) {
        SynchronizationManager synchronizationManager = this;
        synchronizationManager.shouldSync = false;
        synchronizationManager.isSyncing = false;
        synchronizationManager.syncAction = new Consumer<Long>(){

            private boolean shouldSync() {
                return SynchronizationManager.this.shouldSync && SynchronizationManager.this.handler != null && SynchronizationManager.this.syncRunnable != null;
            }

            public void accept(Long l) {
                if (this.shouldSync() && SynchronizationManager.this.handler != null && SynchronizationManager.this.syncRunnable != null) {
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("Waiting " + l + " seconds until the next chats sync"));
                    SynchronizationManager.this.handler.postDelayed((Runnable)SynchronizationManager.this.syncRunnable, l * 1000L);
                }
            }
        };
        synchronizationManager.chattingTimeUpdateAction = l -> this.sync(false);
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                2 v0 = this;
                SynchronizationManager.access$002(v0.SynchronizationManager.this, new Handler());
                SynchronizationManager synchronizationManager = v0.SynchronizationManager.this;
                SynchronizationManager.access$102(synchronizationManager, synchronizationManager.new SyncRunnable(context));
                v0.SynchronizationManager.this.subscribeToChatTimeUpdatedEvents();
            }
        });
    }

    public static void init(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new SynchronizationManager(context);
        }
    }

    public static synchronized SynchronizationManager getInstance() {
        if (INSTANCE == null && Instabug.getApplicationContext() != null) {
            SynchronizationManager.init(Instabug.getApplicationContext());
        }
        return INSTANCE;
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    static void tearDown() {
        INSTANCE = null;
    }

    private boolean isSyncing() {
        return this.isSyncing;
    }

    private void syncMessages(final Context context, final Consumer<Long> consumer) {
        if (RepliesWrapper.isMessagingServiceAvailable()) {
            this.isSyncing = true;
            final List<ReadMessage> list = ReadQueueCacheManager.getInstance().getAll();
            try {
                MessagingService.getInstance().syncMessages(ChatsCacheManager.getLastMessageMessagedAt(), ChatsCacheManager.getTotalMessagesCount(), ReadQueueCacheManager.getInstance().getReadMessagesArray(), new Request.Callbacks<RequestResponse, Throwable>(){

                    public void onSucceeded(@Nullable RequestResponse requestResponse) {
                        if (requestResponse != null) {
                            RequestResponse requestResponse2 = requestResponse;
                            3 v1 = this;
                            requestResponse = v1.context;
                            SynchronizationManager.this.handleSuccessResponse(requestResponse2, (Context)requestResponse, (Consumer<Long>)v1.consumer);
                        }
                        SynchronizationManager.this.clearReadMessages(list);
                    }

                    public void onFailed(Throwable throwable) {
                        SynchronizationManager.this.handleFailureResponse((Consumer<Long>)consumer);
                    }
                });
            }
            catch (JSONException jSONException) {
                this.handleFailureResponse(consumer);
            }
        } else {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Can't sync chats because device is offline");
            try {
                consumer.accept((Object)ChatSettings.getTTL());
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Syncing chats got error: " + exception.getMessage()));
            }
        }
    }

    private void handleSuccessResponse(RequestResponse requestResponse, Context context, Consumer<Long> consumer) {
        block8: {
            InstabugSDKLogger.d((String)"IBG-BR", (String)"Chats synced successfully");
            this.isSyncing = false;
            Object object = requestResponse.getResponseBody();
            if (!(object instanceof String)) break block8;
            RequestResponse requestResponse2 = requestResponse;
            requestResponse = this.parseReceivedMessages((String)object);
            boolean bl = requestResponse2.getResponseCode() == 203;
            try {
                SynchronizationManager synchronizationManager = this;
                this.handleReceivedMessages(context, (JSONArray)requestResponse, bl);
                synchronizationManager.handleTTL(synchronizationManager.parseTTL((String)object), consumer);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Exception was occurred," + exception.getMessage() + " while handling chats sync response"), (Throwable)exception);
                try {
                    consumer.accept((Object)ChatSettings.getTTL());
                }
                catch (Exception exception2) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("Exception was occurred," + exception2.getMessage()));
                }
            }
        }
    }

    private void handleFailureResponse(Consumer<Long> consumer) {
        InstabugSDKLogger.e((String)"IBG-BR", (String)"Something went wrong while sync messages");
        this.isSyncing = false;
        try {
            consumer.accept((Object)ChatSettings.getTTL());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)("Exception was occurred while sync messages," + exception.getMessage()));
        }
    }

    private long parseTTL(String string2) {
        return new JSONObject(string2).getLong("ttl");
    }

    private void handleTTL(long l, Consumer<Long> consumer) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Next TTL: " + l));
        if (l != -1L) {
            long l2 = l;
            ChatSettings.setTTL(l2);
            try {
                consumer.accept((Object)l2);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Exception was occurred while handling TTL," + exception.getMessage()));
            }
        }
    }

    private JSONArray parseReceivedMessages(String string2) {
        return new JSONObject(string2).getJSONArray("missing_messages");
    }

    private void handleReceivedMessages(Context context, JSONArray jSONArray, boolean bl) {
        JSONObject[] jSONObjectArray = new JSONObject[]{};
        if (jSONArray.length() != 0) {
            InstabugSDKLogger.v((String)"IBG-BR", (String)(jSONArray.length() + "new messages received"));
            jSONObjectArray = new JSONObject[jSONArray.length()];
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONObjectArray[i] = jSONArray.getJSONObject(i);
            }
        }
        NewMessagesHandler.getInstance().handleNewMessagesReceived(context, bl, jSONObjectArray);
    }

    private void clearReadMessages(List<ReadMessage> list) {
        ReadQueueCacheManager.getInstance().notify(list);
    }

    private void subscribeToChatTimeUpdatedEvents() {
        this.chatTimeSubscriber = ChatTimeUpdatedEventBus.getInstance().subscribe(this.chattingTimeUpdateAction);
    }

    private void unSubscribeToChatTimeUpdatedEvents() {
        SynchronizationManager synchronizationManager = synchronizationManager.chatTimeSubscriber;
        if (synchronizationManager != null) {
            synchronizationManager.dispose();
        }
    }

    private void resetTTL() {
        ChatSettings.setTTL(0L);
    }

    static /* synthetic */ Handler access$002(SynchronizationManager synchronizationManager, Handler handler) {
        synchronizationManager.handler = handler;
        return handler;
    }

    static /* synthetic */ SyncRunnable access$102(SynchronizationManager synchronizationManager, SyncRunnable syncRunnable) {
        synchronizationManager.syncRunnable = syncRunnable;
        return syncRunnable;
    }

    private class SyncRunnable
    implements Runnable {
        WeakReference<Context> contextWeakReference;

        SyncRunnable(Context context) {
            WeakReference<Context> weakReference;
            WeakReference<Context> weakReference2 = weakReference;
            weakReference = new WeakReference<Context>(context);
            v1.contextWeakReference = weakReference2;
        }

        @Override
        public void run() {
            if (RepliesWrapper.isMessagingServiceAvailable()) {
                PoolProvider.postIOTaskWithCheck((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WeakReference<Context> weakReference = SyncRunnable.this.contextWeakReference;
                        if (weakReference != null && weakReference.get() != null) {
                            weakReference = SyncRunnable.this;
                            ((SyncRunnable)((Object)weakReference)).SynchronizationManager.this.syncMessages((Context)((SyncRunnable)((Object)weakReference)).contextWeakReference.get(), (Consumer<Long>)SynchronizationManager.this.syncAction);
                        } else {
                            try {
                                SynchronizationManager.this.syncAction.accept((Object)ChatSettings.getTTL());
                            }
                            catch (Exception exception) {
                                InstabugSDKLogger.e((String)"IBG-BR", (String)("Exception was occurred," + exception.getMessage()));
                            }
                        }
                    }
                });
            }
        }
    }
}

