/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.MessageAction;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.tokenmapping.TokenMappingServiceLocator;
import com.instabug.library.user.UserManagerWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Message
implements Cacheable,
Serializable {
    private String id;
    @Nullable
    private String chatId;
    @Nullable
    private String body;
    @Nullable
    private String senderName;
    @Nullable
    private String senderAvatarUrl;
    private long messagedAt;
    private boolean isRead;
    private long readAt;
    private ArrayList<Attachment> attachments;
    private ArrayList<MessageAction> actions;
    private Direction direction;
    private MessageState messageState;
    @Nullable
    private String requesterName;
    private String requesterEmail;
    private String deviceToken;
    @Nullable
    private String appToken;

    public String getId() {
        return this.id;
    }

    public Message setId(String string2) {
        this.id = string2;
        return this;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public Message setChatId(String string2) {
        this.chatId = string2;
        return this;
    }

    @Nullable
    public String getBody() {
        return this.body;
    }

    public Message setBody(String string2) {
        this.body = string2;
        return this;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public Message setRead(boolean bl) {
        this.isRead = bl;
        return this;
    }

    public long getReadAt() {
        return this.readAt;
    }

    public Message setReadAt(long l) {
        this.readAt = l;
        if (l != 0L) {
            this.isRead = true;
        }
        return this;
    }

    public long getMessagedAt() {
        return this.messagedAt;
    }

    public Message setMessagedAt(long l) {
        this.messagedAt = l;
        return this;
    }

    @Nullable
    public String getSenderName() {
        return this.senderName;
    }

    public Message setSenderName(@Nullable String string2) {
        this.senderName = string2;
        return this;
    }

    @Nullable
    public String getSenderAvatarUrl() {
        return this.senderAvatarUrl;
    }

    public Message setSenderAvatarUrl(String string2) {
        this.senderAvatarUrl = string2;
        return this;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public Message setMessageState(MessageState messageState) {
        this.messageState = messageState;
        return this;
    }

    public ArrayList<Attachment> getAttachments() {
        return this.attachments;
    }

    public Message setAttachments(@NonNull ArrayList<Attachment> arrayList) {
        this.attachments = arrayList;
        return this;
    }

    public Message addAttachment(Attachment attachment) {
        Message message = this;
        message.attachments.add(attachment);
        return message;
    }

    public ArrayList<MessageAction> getActions() {
        return this.actions;
    }

    public Message setActions(ArrayList<MessageAction> arrayList) {
        this.actions = arrayList;
        return this;
    }

    public Message addAction(MessageAction messageAction) {
        Message message = this;
        message.actions.add(messageAction);
        return message;
    }

    public Direction getMessageDirection() {
        return this.direction;
    }

    public Message setDirection(Direction direction) {
        this.direction = direction;
        if (direction == Direction.INBOUND) {
            this.isRead = true;
        }
        return this;
    }

    @Nullable
    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String string2) {
        this.appToken = string2;
    }

    @Nullable
    public String getRequesterName() {
        return this.requesterName;
    }

    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public boolean isInbound() {
        Object object = object.direction;
        return object != null && object == Direction.INBOUND;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() {
        JSONObject jSONObject = new JSONObject();
        long l = this.getMessagedAt();
        JSONObject jSONObject2 = jSONObject.put("id", (Object)this.getId()).put("chat_id", (Object)this.getChatId()).put("body", (Object)this.getBody()).put("sender_name", (Object)this.getSenderName()).put("sender_avatar_url", (Object)this.getSenderAvatarUrl()).put("messaged_at", l).put("read", this.isRead());
        l = this.getReadAt();
        jSONObject2.put("read_at", l).put("messages_state", (Object)((Object)((Object)this.getMessageState())).toString()).put("direction", (Object)this.getMessageDirection().toString()).put("attachments", (Object)Attachment.toJson(this.getAttachments())).put("actions", (Object)MessageAction.toJson(this.getActions())).put("application_token", (Object)this.getAppToken());
        return jSONObject.toString();
    }

    public void fromJson(String object) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject(object);
        if (jSONObject2.has("id")) {
            this.setId(jSONObject2.getString("id"));
        }
        if (jSONObject2.has("chat_id")) {
            this.setChatId(jSONObject2.getString("chat_id"));
        }
        if (jSONObject2.has("body")) {
            this.setBody(jSONObject2.getString("body"));
        }
        if (jSONObject2.has("sender_name")) {
            this.setSenderName(jSONObject2.getString("sender_name"));
        }
        if (jSONObject2.has("sender_avatar_url")) {
            this.setSenderAvatarUrl(jSONObject2.getString("sender_avatar_url"));
        }
        if (jSONObject2.has("messaged_at")) {
            this.setMessagedAt(jSONObject2.getLong("messaged_at"));
        }
        if (jSONObject2.has("read")) {
            this.setRead(jSONObject2.getBoolean("read"));
        }
        if (jSONObject2.has("read_at")) {
            this.setReadAt(jSONObject2.getLong("read_at"));
        }
        if (jSONObject2.has("attachments")) {
            this.setAttachments(Attachment.fromJson(jSONObject2.getJSONArray("attachments")));
        }
        if (jSONObject2.has("actions")) {
            this.setActions(MessageAction.fromJson(jSONObject2.getJSONArray("actions")));
        }
        if (jSONObject2.has("direction")) {
            object = jSONObject2.getString("direction");
            object.hashCode();
            object = !object.equals("outbound") ? (!object.equals("inbound") ? Direction.NOT_AVAILABLE : Direction.INBOUND) : Direction.OUTBOUND;
            this.setDirection((Direction)((Object)object));
        }
        if (jSONObject2.has("messages_state")) {
            this.setMessageState(MessageState.valueOf(jSONObject2.getString("messages_state")));
        }
        if (jSONObject2.has("application_token")) {
            this.setAppToken(jSONObject2.getString("application_token"));
        }
    }

    @NonNull
    public String toString() {
        return "Message:[" + this.id + ", " + this.chatId + ", " + this.body + ", " + this.messagedAt + ", " + this.readAt + ", " + this.senderName + ", " + this.senderAvatarUrl + ", " + (Object)((Object)this.messageState) + ", " + (Object)((Object)this.direction) + ", " + this.isRead + ", " + this.attachments + "]";
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION"})
    public boolean equals(Object object) {
        if (object != null && object instanceof Message) {
            if (String.valueOf(((Message)(object = (Message)object)).getId()).equals(String.valueOf(this.getId())) && String.valueOf(((Message)object).getChatId()).equals(String.valueOf(this.getChatId())) && String.valueOf(((Message)object).getSenderName()).equals(String.valueOf(this.getSenderName())) && String.valueOf(((Message)object).getSenderAvatarUrl()).equals(String.valueOf(this.getSenderAvatarUrl())) && String.valueOf(((Message)object).getBody()).equals(String.valueOf(this.getBody())) && ((Message)object).getMessagedAt() == this.getMessagedAt() && ((Message)object).getMessageState() == this.getMessageState() && ((Message)object).getMessageDirection() == this.getMessageDirection() && ((Message)object).isInbound() == this.isInbound() && ((Message)object).isRead() == this.isRead() && ((Message)object).getReadAt() == this.getReadAt() && ((Message)object).getAttachments() != null && ((Message)object).getAttachments().size() == this.getAttachments().size() && ((Message)object).getActions() != null && ((Message)object).getActions().size() == this.getActions().size()) {
                int n;
                for (n = 0; n < ((Message)object).getAttachments().size(); ++n) {
                    if (((Message)object).getAttachments().get(n).equals(this.getAttachments().get(n))) continue;
                    return false;
                }
                for (n = 0; n < ((Message)object).getActions().size(); ++n) {
                    if (((Message)object).getActions().get(n).equals(this.getActions().get(n))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return -1;
    }

    public Message(@Nullable String string2, String string3, String string4) {
        this(String.valueOf(System.currentTimeMillis()), string2, string3, string4);
    }

    public Message(String string2, @Nullable String string3, String string4, String string5) {
        Message message = this;
        Message message2 = this;
        message2.id = string2;
        message2.attachments = new ArrayList();
        message2.actions = new ArrayList();
        message2.direction = Direction.NOT_AVAILABLE;
        message2.messageState = MessageState.NOT_AVAILABLE;
        this.requesterName = string3;
        this.requesterEmail = string4;
        message.deviceToken = string5;
        message.appToken = TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken();
    }

    public static JSONArray toJson(ArrayList<Message> arrayList) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            jSONArray2.put((Object)new JSONObject(arrayList.get(i).toJson()));
        }
        return jSONArray2;
    }

    public static ArrayList<Message> fromJson(JSONArray jSONArray) {
        ArrayList<Message> arrayList;
        ArrayList<Message> arrayList2 = arrayList;
        arrayList = new ArrayList<Message>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            Message message;
            Message message2 = message;
            message2(UserManagerWrapper.getUserName(), UserManagerWrapper.getUserEmail(), InstabugCore.getPushNotificationToken());
            message.fromJson(jSONArray.getJSONObject(i).toString());
            arrayList2.add(message);
        }
        return arrayList2;
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND("outbound"),
        NOT_AVAILABLE("not-available");

        private final String direction;

        private Direction(String string3) {
            this.direction = string3;
        }

        @NotNull
        public String toString() {
            return this.direction;
        }
    }

    public static enum MessageState {
        STAY_OFFLINE,
        READY_TO_BE_SENT,
        SENT,
        READY_TO_BE_SYNCED,
        SYNCED,
        NOT_AVAILABLE;

    }

    public static class Comparator
    implements java.util.Comparator<Message>,
    Serializable {
        private int compareBy;

        public Comparator() {
            this.compareBy = 2;
        }

        public Comparator(int n) {
            this.compareBy = n;
        }

        @Override
        public int compare(Message message, Message message2) {
            if (message != null && message2 != null) {
                int n = this.compareBy;
                if (n != 1) {
                    if (n != 2) {
                        throw new IllegalStateException("Message comparator wasn't provided comparison messageIssueType");
                    }
                } else if (message.getChatId() != null && message2.getChatId() != null) {
                    return message.getChatId().compareTo(message2.getChatId());
                }
                return new Date(message.getMessagedAt()).compareTo(new Date(message2.getMessagedAt()));
            }
            return 0;
        }
    }
}

