/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.cache;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.chat.model.Message;
import com.instabug.chat.model.ReadMessage;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReadQueueCacheManager {
    @Nullable
    private static ReadQueueCacheManager mReadQueueCacheManager;

    private ReadQueueCacheManager() {
        InMemoryCache inMemoryCache;
        ReadQueueCacheManager readQueueCacheManager = inMemoryCache;
        inMemoryCache = new InMemoryCache("read_queue_memory_cache_key");
        CacheManager.getInstance().addCache((Cache)readQueueCacheManager);
    }

    public static ReadQueueCacheManager getInstance() {
        if (mReadQueueCacheManager == null) {
            mReadQueueCacheManager = new ReadQueueCacheManager();
        }
        return mReadQueueCacheManager;
    }

    public static void saveCacheToDisk() {
        Object object = CacheManager.getInstance().getCache("read_queue_memory_cache_key");
        Cache cache = CacheManager.getInstance().getCache("read_queue_disk_cache_key");
        if (object != null && cache != null) {
            CacheManager.KeyExtractor<String, ReadMessage> keyExtractor;
            InstabugSDKLogger.d((String)"IBG-BR", (String)("Saving In-memory cache to disk, no. of items to save is " + object.getValues()));
            Cache cache2 = object;
            object = keyExtractor;
            keyExtractor = new CacheManager.KeyExtractor<String, ReadMessage>(){

                public String extractKey(ReadMessage readMessage) {
                    return String.valueOf(readMessage.getChatNumber());
                }
            };
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)object);
            return;
        }
    }

    private void remove(String string2) {
        ReadQueueCacheManager readQueueCacheManager = CacheManager.getInstance().getCache("read_queue_memory_cache_key");
        if (readQueueCacheManager != null) {
            readQueueCacheManager.delete(string2);
        }
    }

    public void add(ReadMessage readMessage) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)"Adding message to read queue in-memory cache");
        ReadQueueCacheManager readQueueCacheManager = CacheManager.getInstance().getCache("read_queue_memory_cache_key");
        if (readQueueCacheManager != null && readMessage != null && readMessage.getChatNumber() != null) {
            readQueueCacheManager.put(readMessage.getChatNumber(), readMessage);
            InstabugSDKLogger.v((String)"IBG-BR", (String)("Added message to read queue in-memory cache " + readQueueCacheManager.size()));
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public JSONArray getReadMessagesArray() {
        JSONArray jSONArray;
        ReadQueueCacheManager readQueueCacheManager2;
        ReadQueueCacheManager readQueueCacheManager = readQueueCacheManager2;
        readQueueCacheManager2 = jSONArray;
        jSONArray = new JSONArray();
        for (ReadMessage jSONException : readQueueCacheManager.getAll()) {
            String string2;
            ReadMessage readMessage;
            JSONObject jSONObject;
            ReadMessage readMessage2;
            JSONObject jSONObject2;
            ReadMessage readMessage3;
            JSONObject jSONObject3;
            JSONObject jSONObject4 = jSONObject3;
            try {
                readMessage3 = jSONException;
                jSONObject2 = jSONObject4;
                readMessage2 = jSONException;
                jSONObject = jSONObject4;
                readMessage = jSONException;
                jSONObject4();
                string2 = "chat_number";
            }
            catch (JSONException jSONException2) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Error: " + jSONException2.getMessage() + " occurred while getting read messages"));
                continue;
            }
            jSONObject.put(string2, (Object)readMessage.getChatNumber());
            String string3 = "message_id";
            jSONObject2.put(string3, (Object)readMessage2.getMessageId());
            String string4 = "read_at";
            long l = readMessage3.getReadAt();
            jSONObject3.put(string4, l);
            readQueueCacheManager2.put(jSONObject3);
        }
        return readQueueCacheManager2;
    }

    public List<ReadMessage> getAll() {
        ReadQueueCacheManager readQueueCacheManager = CacheManager.getInstance().getCache("read_queue_memory_cache_key");
        if (readQueueCacheManager != null) {
            return readQueueCacheManager.getValues();
        }
        return new ArrayList<ReadMessage>();
    }

    public void notify(List<ReadMessage> list) {
        for (ReadMessage readMessage : this.getAll()) {
            for (ReadMessage readMessage2 : list) {
                if (readMessage.getChatNumber() == null || !readMessage.getChatNumber().equals(readMessage2.getChatNumber()) || readMessage.getMessageId() == null || !readMessage.getMessageId().equals(readMessage2.getMessageId()) || readMessage2.getChatNumber() == null) continue;
                this.remove(readMessage2.getChatNumber());
            }
        }
    }

    public void markAsRead(@NonNull Message message) {
        ReadQueueCacheManager readQueueCacheManager = this;
        readQueueCacheManager.add(readQueueCacheManager.map(message));
    }

    @VisibleForTesting
    ReadMessage map(@NonNull Message message) {
        ReadMessage readMessage;
        ReadMessage readMessage2 = readMessage;
        readMessage2();
        readMessage2.setChatNumber(message.getChatId());
        readMessage.setMessageId(message.getId());
        readMessage.setReadAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds());
        return readMessage;
    }
}

