/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.instabug.bug.R;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivity;
import com.instabug.chat.RepliesWrapper;
import com.instabug.chat.cache.CacheUtility;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.network.InstabugPushNotificationTokenJob;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.synchronization.SynchronizationManager;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import java.util.ArrayList;

abstract class ChatPluginWrapper {
    private static void initSynchronization(Context context) {
        SynchronizationManager.init(context);
    }

    static void wake(Context context) {
        Context context2 = context;
        ChatSettings.init(context2);
        CacheUtility.prepareCache(context2);
        CacheUtility.cleanupChats();
        ChatPluginWrapper.initSynchronization(context2);
    }

    static void release() {
        ChatPluginWrapper.releaseSynchronization();
        CacheUtility.dumpCache();
        ChatSettings.release();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    private static void releaseSynchronization() {
        SynchronizationManager.getInstance().release();
    }

    static long getLastActivityTime() {
        return ChatSettings.getLastChatTime();
    }

    static ArrayList<PluginPromptOption> getPromptOptions(Context context) {
        ArrayList<PluginPromptOption> arrayList;
        ArrayList<PluginPromptOption> arrayList2 = arrayList;
        arrayList = new ArrayList<PluginPromptOption>();
        if (ChatPluginWrapper.isChatFeatureEnabled() && InstabugCore.isFeatureEnabled((String)"REPLIES") && RepliesWrapper.hasChats()) {
            arrayList2.add(ChatPluginWrapper.getChatsListOption(context));
        }
        return arrayList2;
    }

    private static PluginPromptOption getChatsListOption(final Context context) {
        PluginPromptOption pluginPromptOption = new PluginPromptOption();
        pluginPromptOption.setOrder(-1);
        pluginPromptOption.setInvocationMode(4);
        pluginPromptOption.setInitialScreenshotRequired(false);
        pluginPromptOption.setNotificationCount(ChatsCacheManager.getUnreadCount());
        pluginPromptOption.setPromptOptionIdentifier(2);
        pluginPromptOption.setIcon(R.drawable.ibg_core_ic_talk_to_us);
        pluginPromptOption.setOnInvocationListener(new PluginPromptOption.OnInvocationListener(){

            public void onInvoke(@Nullable Uri uri, String ... stringArray) {
                1 v0 = this_;
                1 this_ = InstabugDialogActivity.getIntent(v0.context, null, null, null, true);
                v0.context.startActivity((Intent)this_);
                RepliesWrapper.show();
            }
        });
        return pluginPromptOption;
    }

    private static boolean isChatFeatureEnabled() {
        return InstabugCore.getFeatureState((String)"IN_APP_MESSAGING") == Feature.State.ENABLED;
    }

    public static void initDefaultPromptOptionAvailabilityState() {
        InvocationManager.getInstance().notifyInvocationOptionChanged();
    }

    public static void sendPushNotificationToken(boolean bl) {
        if (bl) {
            InstabugCore.setPushNotificationTokenSent((boolean)false);
        }
        String string2 = InstabugCore.getPushNotificationToken();
        if (!InstabugCore.isPushNotificationTokenSent() && string2 != null && !string2.isEmpty() && Instabug.getApplicationContext() != null) {
            InstabugPushNotificationTokenJob.getInstance().start();
        }
    }
}

