/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat;

import android.content.Context;
import com.instabug.chat.ChatPluginWrapper;
import com.instabug.chat.cache.CacheUtility;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.chat.network.InstabugMessageUploaderJob;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.synchronization.SynchronizationManager;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.util.threading.PoolProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\u0012\u0010\u000f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lcom/instabug/chat/ChatCoreEventHandler;", "", "()V", "isChatFeatureEnabled", "", "()Z", "handleCoreEvents", "", "context", "Landroid/content/Context;", "coreEvent", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "handleEncryptionStateChange", "handleNetworkActivated", "handleSessionFinished", "handleSessionStart", "handleUserLogin", "handleUserLogout", "startBackgroundTasks", "instabug-bug_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nChatCoreEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCoreEventHandler.kt\ncom/instabug/chat/ChatCoreEventHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class ChatCoreEventHandler {
    @NotNull
    public static final ChatCoreEventHandler INSTANCE = new ChatCoreEventHandler();

    private ChatCoreEventHandler() {
    }

    private final boolean isChatFeatureEnabled() {
        return InstabugCore.getFeatureState((String)"IN_APP_MESSAGING") == Feature.State.ENABLED;
    }

    @JvmStatic
    public static final void handleCoreEvents(@Nullable Context context, @NotNull IBGSdkCoreEvent iBGSdkCoreEvent) {
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent, (String)"coreEvent");
        ChatCoreEventHandler chatCoreEventHandler = INSTANCE;
        if (chatCoreEventHandler.isChatFeatureEnabled()) {
            if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.NetworkActivated.INSTANCE)) {
                chatCoreEventHandler.handleNetworkActivated();
            } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.Session.SessionStarted.INSTANCE)) {
                chatCoreEventHandler.handleSessionStart(context);
            } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.Session.SessionFinished.INSTANCE)) {
                chatCoreEventHandler.handleSessionFinished();
            } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.User.LoggedIn.INSTANCE)) {
                chatCoreEventHandler.handleUserLogin();
            } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.User.LoggedOut.INSTANCE)) {
                chatCoreEventHandler.handleUserLogout();
            } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.EncryptionStateChanged.INSTANCE)) {
                chatCoreEventHandler.handleEncryptionStateChange();
            }
        }
    }

    private final void handleEncryptionStateChange() {
        ChatsCacheManager.migrateOnEncryptionStateChange();
    }

    private final void handleNetworkActivated() {
        CacheUtility.dumpCache();
        this.startBackgroundTasks();
        SynchronizationManager.getInstance().sync(false);
    }

    private final void handleUserLogin() {
        SynchronizationManager.getInstance().sync(true);
    }

    private final void handleUserLogout() {
        ChatSettings.setLastChatTime(0L);
    }

    private final void startBackgroundTasks() {
        PoolProvider.postIOTask(ChatCoreEventHandler::startBackgroundTasks$lambda$0);
    }

    private final void handleSessionStart(Context context) {
        if (context != null) {
            CacheUtility.prepareCache(context);
        }
        SynchronizationManager.getInstance().sync(false);
        ChatPluginWrapper.sendPushNotificationToken(false);
    }

    private final void handleSessionFinished() {
        CacheUtility.dumpCache();
        this.startBackgroundTasks();
        SynchronizationManager.getInstance().stop();
    }

    private static final void startBackgroundTasks$lambda$0() {
        block3: {
            block2: {
                List<Chat> list = ChatsCacheManager.getOfflineChats();
                List<Message> list2 = ChatsCacheManager.getOfflineMessages();
                Intrinsics.checkNotNullExpressionValue(list, (String)"offlineChats");
                if (!list.isEmpty()) break block2;
                List<Message> list3 = list2;
                Intrinsics.checkNotNullExpressionValue(list3, (String)"offlineMessages");
                if (list3.isEmpty()) break block3;
            }
            InstabugMessageUploaderJob.getInstance().start();
        }
    }
}

