/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.view.IconView;
import java.util.Locale;

public abstract class FloatingActionButton
extends IconView {
    int mColorNormal;
    int mColorPressed;
    int mColorDisabled;
    @Nullable
    String mTitle;
    @DrawableRes
    private int mIcon;
    @Nullable
    private Drawable mIconDrawable;
    private int mSize;
    private float mCircleSize;
    private float mShadowRadius;
    private float mShadowOffset;
    private int mDrawableSize;
    boolean mStrokeVisible;

    public FloatingActionButton(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public FloatingActionButton(Context context, @Nullable AttributeSet attributeSet, int n) {
        FloatingActionButton floatingActionButton = this;
        super(context, attributeSet, n);
        floatingActionButton.init(context, attributeSet);
    }

    private void updateDrawableSize() {
        this.mDrawableSize = (int)(this.mCircleSize + this.mShadowRadius * 2.0f);
    }

    private void updateCircleSize() {
        int n = this.mSize == 0 ? R.dimen.instabug_fab_size_normal : R.dimen.instabug_fab_size_mini;
        this.mCircleSize = this.getDimension(n);
    }

    private StateListDrawable createFillDrawable(float f) {
        StateListDrawable stateListDrawable;
        StateListDrawable stateListDrawable2 = stateListDrawable;
        FloatingActionButton floatingActionButton = object;
        FloatingActionButton floatingActionButton2 = object;
        FloatingActionButton floatingActionButton3 = object;
        stateListDrawable2();
        int[] nArray = new int[1];
        Object object = nArray;
        nArray[0] = -16842910;
        stateListDrawable2.addState((int[])object, floatingActionButton3.createCircleDrawable(floatingActionButton3.mColorDisabled, f));
        int[] nArray2 = new int[1];
        object = nArray2;
        nArray2[0] = 16842919;
        stateListDrawable2.addState((int[])object, floatingActionButton2.createCircleDrawable(floatingActionButton2.mColorPressed, f));
        object = new int[0];
        stateListDrawable.addState((int[])object, floatingActionButton.createCircleDrawable(floatingActionButton.mColorNormal, f));
        return stateListDrawable;
    }

    private Drawable createCircleDrawable(int n, float f) {
        Object object;
        Drawable[] drawableArray;
        ShapeDrawable shapeDrawable;
        int n2 = Color.alpha((int)n);
        FloatingActionButton floatingActionButton = object;
        n = floatingActionButton.opaque(n);
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        Drawable[] drawableArray2 = drawableArray;
        drawableArray = new OvalShape();
        Paint paint = new ShapeDrawable((Shape)drawableArray2).getPaint();
        paint.setAntiAlias(true);
        paint.setColor(n);
        Drawable drawable2 = floatingActionButton.createInnerStrokesDrawable(n, f);
        Drawable[] drawableArray3 = new Drawable[2];
        drawableArray2 = drawableArray3;
        drawableArray3[0] = shapeDrawable2;
        drawableArray3[1] = drawable2;
        if (n2 != 255 && object.mStrokeVisible) {
            TranslucentLayerDrawable translucentLayerDrawable;
            object = translucentLayerDrawable;
            translucentLayerDrawable = new TranslucentLayerDrawable(n2, drawableArray2);
        } else {
            LayerDrawable layerDrawable;
            object = layerDrawable;
            layerDrawable = new LayerDrawable(drawableArray2);
        }
        Object object2 = object;
        int n3 = (int)(f / 2.0f);
        object2.setLayerInset(1, n3, n3, n3, n3);
        return object2;
    }

    private Drawable createOuterStrokeDrawable(float f) {
        Paint paint;
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        Paint paint2 = paint = shapeDrawable.getPaint();
        paint.setAntiAlias(true);
        paint2.setStrokeWidth(f);
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setColor(-16777216);
        paint.setAlpha(this.opacityToAlpha(0.02f));
        return shapeDrawable;
    }

    private int opacityToAlpha(float f) {
        return (int)(f * 255.0f);
    }

    private int darkenColor(int n) {
        return this.adjustColorBrightness(n, 0.9f);
    }

    private int lightenColor(int n) {
        return this.adjustColorBrightness(n, 1.1f);
    }

    private int adjustColorBrightness(int n, float f) {
        float[] fArray = new float[3];
        Object object = fArray;
        Color.colorToHSV((int)n, (float[])object);
        fArray[2] = Math.min(fArray[2] * f, 1.0f);
        return Color.HSVToColor((int)Color.alpha((int)n), (float[])object);
    }

    private int halfTransparent(int n) {
        int n2 = Color.alpha((int)n) / 2;
        int n3 = n;
        int n4 = Color.red((int)n3);
        n = Color.green((int)n3);
        int n5 = Color.blue((int)n3);
        return Color.argb((int)n2, (int)n4, (int)n, (int)n5);
    }

    private int opaque(int n) {
        int n2 = n;
        int n3 = Color.green((int)n2);
        return Color.rgb((int)Color.red((int)n), (int)n3, (int)Color.blue((int)n2));
    }

    private Drawable createInnerStrokesDrawable(final int n, float f) {
        ShapeDrawable shapeDrawable;
        if (!this.mStrokeVisible) {
            return new ColorDrawable(0);
        }
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        FloatingActionButton floatingActionButton = this;
        FloatingActionButton floatingActionButton2 = this;
        shapeDrawable2((Shape)new OvalShape());
        final int n2 = floatingActionButton2.darkenColor(n);
        final int n3 = floatingActionButton2.halfTransparent(n2);
        final int n4 = floatingActionButton.lightenColor(n);
        final int n5 = floatingActionButton.halfTransparent(n4);
        Paint paint = shapeDrawable.getPaint();
        paint.setAntiAlias(true);
        paint.setStrokeWidth(f);
        paint.setStyle(Paint.Style.STROKE);
        shapeDrawable.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int n7, int n22) {
                2 v0 = this;
                float f = (float)n7 / 2.0f;
                float f2 = n22;
                n22 = v0.n4;
                int n32 = v0.n5;
                int n42 = v0.n;
                int n52 = v0.n3;
                int n6 = v0.n2;
                int[] nArray = new int[5];
                int[] nArray2 = nArray;
                nArray[0] = n22;
                nArray[1] = n32;
                nArray[2] = n42;
                nArray[3] = n52;
                nArray[4] = n6;
                float[] fArray = new float[5];
                float[] fArray2 = fArray;
                fArray[0] = 0.0f;
                fArray[1] = 0.2f;
                fArray[2] = 0.5f;
                fArray[3] = 0.8f;
                fArray[4] = 1.0f;
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                return new LinearGradient(f, 0.0f, f, f2, nArray2, fArray2, tileMode);
            }
        });
        return shapeDrawable;
    }

    private void setBackgroundCompat(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    void init(Context context, @Nullable AttributeSet attributeSet) {
        FloatingActionButton floatingActionButton = this;
        context = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionButton, 0, 0);
        this.mColorNormal = context.getColor(R.styleable.FloatingActionButton_instabug_fab_colorNormal, -1);
        this.mColorPressed = context.getColor(R.styleable.FloatingActionButton_instabug_fab_colorPressed, -3355444);
        this.mColorDisabled = context.getColor(R.styleable.FloatingActionButton_instabug_fab_colorDisabled, Color.parseColor((String)"#EFEFF4"));
        this.mSize = context.getInt(R.styleable.FloatingActionButton_instabug_fab_size, 0);
        this.mIcon = context.getResourceId(R.styleable.FloatingActionButton_instabug_fab_icon, 0);
        this.mTitle = context.getString(R.styleable.FloatingActionButton_instabug_fab_title);
        this.mStrokeVisible = context.getBoolean(R.styleable.FloatingActionButton_instabug_fab_stroke_visible, true);
        context.recycle();
        floatingActionButton.updateCircleSize();
        floatingActionButton.mShadowRadius = floatingActionButton.getDimension(R.dimen.instabug_fab_shadow_radius);
        floatingActionButton.mShadowOffset = floatingActionButton.getDimension(R.dimen.instabug_fab_shadow_offset);
        floatingActionButton.updateDrawableSize();
        floatingActionButton.updateBackground();
        FloatingActionButton floatingActionButton2 = this;
        int n = floatingActionButton2.getButtonContentDescription();
        floatingActionButton.setContentDescription(LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)floatingActionButton.getContext()), (int)n, (Context)floatingActionButton2.getContext()));
        ViewCompat.setAccessibilityDelegate((View)floatingActionButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
            }
        });
    }

    @StringRes
    public int getButtonContentDescription() {
        return R.string.ibg_scren_recording_duration_btn_content_description;
    }

    public void setSize(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Use @FAB_SIZE constants only!");
        }
        if (this.mSize != n) {
            FloatingActionButton floatingActionButton = this;
            floatingActionButton.mSize = n;
            floatingActionButton.updateCircleSize();
            floatingActionButton.updateDrawableSize();
            floatingActionButton.updateBackground();
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public void setIcon(@DrawableRes int n) {
        if (this.mIcon != n) {
            this.mIcon = n;
            this.mIconDrawable = null;
            this.updateBackground();
        }
    }

    public void setIconDrawable(@NonNull Drawable drawable2) {
        if (this.mIconDrawable != drawable2) {
            this.mIcon = 0;
            this.mIconDrawable = drawable2;
            this.updateBackground();
        }
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorNormalResId(@ColorRes int n) {
        FloatingActionButton floatingActionButton = this;
        floatingActionButton.setColorNormal(floatingActionButton.getColor(n));
    }

    public void setColorNormal(int n) {
        if (this.mColorNormal != n) {
            this.mColorNormal = n;
            this.updateBackground();
        }
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorPressedResId(@ColorRes int n) {
        FloatingActionButton floatingActionButton = this;
        floatingActionButton.setColorPressed(floatingActionButton.getColor(n));
    }

    public void setColorPressed(int n) {
        if (this.mColorPressed != n) {
            this.mColorPressed = n;
            this.updateBackground();
        }
    }

    public int getColorDisabled() {
        return this.mColorDisabled;
    }

    public void setColorDisabledResId(@ColorRes int n) {
        FloatingActionButton floatingActionButton = this;
        floatingActionButton.setColorDisabled(floatingActionButton.getColor(n));
    }

    public void setColorDisabled(int n) {
        if (this.mColorDisabled != n) {
            this.mColorDisabled = n;
            this.updateBackground();
        }
    }

    public void setStrokeVisible(boolean bl) {
        if (this.mStrokeVisible != bl) {
            this.mStrokeVisible = bl;
            this.updateBackground();
        }
    }

    int getColor(@ColorRes int n) {
        return this.getResources().getColor(n);
    }

    float getDimension(@DimenRes int n) {
        return this.getResources().getDimension(n);
    }

    public void setTitle(String string2) {
        this.mTitle = string2;
        if ((this = this.getLabelView()) != null) {
            this.setText(string2);
        }
    }

    TextView getLabelView() {
        return (TextView)this.getTag(R.id.instabug_fab_label);
    }

    @Nullable
    public String getTitle() {
        return this.mTitle;
    }

    protected void onMeasure(int n, int n2) {
        FloatingActionButton floatingActionButton = this;
        int n3 = floatingActionButton.mDrawableSize;
        floatingActionButton.setMeasuredDimension(n3, n3);
    }

    void updateBackground() {
        FloatingActionButton floatingActionButton = this;
        float f = floatingActionButton.getDimension(R.dimen.instabug_fab_stroke_width);
        float f2 = f / 2.0f;
        Resources resources = floatingActionButton.getResources();
        int n = floatingActionButton.mSize == 0 ? R.drawable.ibg_core_fab_bg_normal : R.drawable.ibg_core_fab_bg_mini;
        FloatingActionButton floatingActionButton2 = this;
        Drawable drawable2 = resources.getDrawable(n);
        resources = this.createFillDrawable(f);
        Drawable drawable3 = floatingActionButton2.createOuterStrokeDrawable(f);
        Drawable drawable4 = floatingActionButton2.getIconDrawable();
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{drawable2, resources, drawable3, drawable4});
        int n2 = this.mSize == 0 ? (int)(this.mCircleSize - this.getDimension(R.dimen.instabug_fab_icon_size_normal)) / 2 : (int)(this.mCircleSize - this.getDimension(R.dimen.instabug_fab_icon_size_mini)) / 2;
        LayerDrawable layerDrawable2 = layerDrawable;
        float f3 = this.mShadowRadius;
        int n3 = (int)f3;
        float f4 = this.mShadowOffset;
        int n4 = (int)(f3 - f4);
        int n5 = (int)(f3 + f4);
        int n6 = n2;
        int n7 = n2;
        int n8 = n3;
        int n9 = n2;
        layerDrawable.setLayerInset(1, n3, n4, n3, n5);
        n3 = (int)((float)n3 - f2);
        n2 = (int)((float)n4 - f2);
        int n10 = (int)((float)n5 - f2);
        layerDrawable.setLayerInset(2, n3, n2, n3, n10);
        n3 = n8 + n9;
        n2 = n4 + n7;
        n10 = n5 + n6;
        layerDrawable2.setLayerInset(3, n3, n2, n3, n10);
        this.setBackgroundCompat((Drawable)layerDrawable2);
    }

    Drawable getIconDrawable() {
        Drawable drawable2 = this.mIconDrawable;
        if (drawable2 != null) {
            return drawable2;
        }
        if (this.mIcon != 0) {
            return this.getResources().getDrawable(this.mIcon);
        }
        return new ColorDrawable(0);
    }

    public void setVisibility(int n) {
        TextView textView = this.getLabelView();
        if (textView != null) {
            textView.setVisibility(n);
        }
        super.setVisibility(n);
    }

    private static class TranslucentLayerDrawable
    extends LayerDrawable {
        private final int mAlpha;

        public TranslucentLayerDrawable(int n, Drawable ... drawableArray) {
            super(drawableArray);
            this.mAlpha = n;
        }

        public void draw(Canvas canvas) {
            Canvas canvas2 = canvas;
            TranslucentLayerDrawable translucentLayerDrawable = this;
            Rect rect = translucentLayerDrawable.getBounds();
            float f = rect.left;
            float f2 = rect.top;
            float f3 = rect.right;
            float f4 = rect.bottom;
            int n = translucentLayerDrawable.mAlpha;
            canvas2.saveLayerAlpha(f, f2, f3, f4, n, 31);
            super.draw(canvas2);
            canvas.restore();
        }
    }
}

