/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenshot;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.instabug.bug.BugPlugin;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.ReportingActivityLauncher;
import com.instabug.bug.model.Bug;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.model.Attachment;
import com.instabug.library.screenshot.ExtraScreenshotHelper;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivexport.functions.Consumer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class ScreenshotHelper
implements ExtraScreenshotHelper.OnCaptureListener {
    private static ScreenshotHelper INSTANCE;
    @Nullable
    private WeakReference<Context> contextWeakReference;
    private final ExtraScreenshotHelper extraScreenshotHelper = new ExtraScreenshotHelper();

    private ScreenshotHelper() {
        InstabugStateEventBus.getInstance().subscribe((Consumer)new Consumer<InstabugState>(){

            public void accept(InstabugState instabugState) {
                if (instabugState == InstabugState.DISABLED) {
                    ScreenshotHelper.this.cancel();
                }
            }
        });
    }

    public static synchronized ScreenshotHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScreenshotHelper();
        }
        return INSTANCE;
    }

    private synchronized void cancel() {
        LiveBugManager.getInstance().removeBug();
        LiveBugManager.getInstance().releaseBug();
        object.extraScreenshotHelper.cancel();
        Object object = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class);
        if (object != null) {
            object.setState(0);
        }
    }

    private void startBugFeedbackActivity(Context context, @Nullable Uri uri) {
        Context context2 = context;
        context2.startActivity(ReportingActivityLauncher.newHangingBugIntent(context2, uri));
    }

    public synchronized void startScreenshotCapturing(Context context) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.extraScreenshotHelper.init((ExtraScreenshotHelper.OnCaptureListener)this);
    }

    public synchronized void onExtraScreenshotCaptured(Uri uri) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Extra screenshot captured, Uri: " + uri));
        this.extraScreenshotHelper.release();
        Object object = LiveBugManager.getInstance().getBug();
        if (object != null) {
            ((Bug)object).addAttachment(uri, Attachment.Type.EXTRA_IMAGE);
            object = this.contextWeakReference;
            if (object != null && (object = (Context)((Reference)object).get()) != null) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"starting feedback activity");
                this.startBugFeedbackActivity((Context)object, uri);
            }
        } else {
            InstabugSDKLogger.w((String)"IBG-BR", (String)"Bug has been released");
        }
    }

    public synchronized void onExtraScreenshotError(Throwable object) {
        ScreenshotHelper screenshotHelper = this;
        screenshotHelper.extraScreenshotHelper.release();
        object = screenshotHelper.contextWeakReference;
        if (object != null && (object = (Context)((Reference)object).get()) != null) {
            this.startBugFeedbackActivity((Context)object, null);
        }
    }
}

