/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.onboardingbugreporting.utils;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.onboardingbugreporting.OnboardingActivity;
import com.instabug.bug.onboardingbugreporting.utils.WelcomeMessageHelperApiContract;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.Instabug;
import com.instabug.library.PresentationManager;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.DefensiveRunnableKt;
import com.instabug.library.util.threading.PoolProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/instabug/bug/onboardingbugreporting/utils/WelcomeMessageHelperApiImp;", "Lcom/instabug/bug/onboardingbugreporting/utils/WelcomeMessageHelperApiContract;", "()V", "welcomeMessageIBGDisposable", "Lcom/instabug/library/core/eventbus/eventpublisher/IBGDisposable;", "handleCoreEvents", "", "welcomeMessageState", "", "coreEvent", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "handleForegroundAvailable", "isCurrentInvocationEventNotNone", "", "openOnBoardingActivity", "openOnBoardingRunnable", "Ljava/lang/Runnable;", "reportOnBoardingError", "resolveActivity", "target", "Landroid/app/Activity;", "onBoardingIntent", "Landroid/content/Intent;", "showIntroMessage", "showWelcomeMessage", "unsubscribeFromIBGWelcomeMessageEvents", "instabug-bug_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nWelcomeMessageHelperApiImp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeMessageHelperApiImp.kt\ncom/instabug/bug/onboardingbugreporting/utils/WelcomeMessageHelperApiImp\n+ 2 DefensiveRunnable.kt\ncom/instabug/library/util/threading/DefensiveRunnableKt\n*L\n1#1,184:1\n49#2,10:185\n*S KotlinDebug\n*F\n+ 1 WelcomeMessageHelperApiImp.kt\ncom/instabug/bug/onboardingbugreporting/utils/WelcomeMessageHelperApiImp\n*L\n73#1:185,10\n*E\n"})
public final class WelcomeMessageHelperApiImp
implements WelcomeMessageHelperApiContract {
    @Nullable
    private IBGDisposable welcomeMessageIBGDisposable;

    private final Runnable openOnBoardingRunnable(int n) {
        return new Runnable(n, this){
            final /* synthetic */ int $welcomeMessageState$inlined;
            final /* synthetic */ WelcomeMessageHelperApiImp this$0;
            {
                this.$welcomeMessageState$inlined = n;
                this.this$0 = welcomeMessageHelperApiImp;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                Object var0_2;
                Throwable throwable2;
                block6: {
                    InstabugInternalTrackingDelegate instabugInternalTrackingDelegate;
                    try {
                        instabugInternalTrackingDelegate = InstabugInternalTrackingDelegate.getInstance();
                        if (instabugInternalTrackingDelegate == null) return;
                    }
                    catch (Throwable throwable2) {
                        break block6;
                    }
                    instabugInternalTrackingDelegate = instabugInternalTrackingDelegate.getTargetActivity();
                    if (instabugInternalTrackingDelegate == null) {
                        return;
                    }
                    if (instabugInternalTrackingDelegate.isFinishing()) return;
                    Intent intent = OnboardingActivity.getIntent((Context)instabugInternalTrackingDelegate, this.$welcomeMessageState$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"onBoardingIntent");
                    if (WelcomeMessageHelperApiImp.access$resolveActivity(this.this$0, (Activity)instabugInternalTrackingDelegate, intent)) {
                        instabugInternalTrackingDelegate.startActivity(intent);
                        return;
                    }
                    WelcomeMessageHelperApiImp.access$reportOnBoardingError(this.this$0, this.$welcomeMessageState$inlined);
                    return;
                }
                Throwable throwable3 = throwable2;
                DefensiveRunnableKt.defensiveLog$default((Throwable)throwable3, null, (int)2, null);
                if (!(throwable3 instanceof OutOfMemoryError)) {
                    var0_2 = null;
                }
                if (var0_2 == null) return;
                DefensiveRunnableKt.reportOOM((OutOfMemoryError)var0_2);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean resolveActivity(Activity activity, Intent intent) {
        WelcomeMessageHelperApiImp welcomeMessageHelperApiImp;
        if (Build.VERSION.SDK_INT >= 33) {
            welcomeMessageHelperApiImp = activity.getPackageManager();
            if (welcomeMessageHelperApiImp == null) return false;
            ResolveInfo resolveInfo = welcomeMessageHelperApiImp.resolveActivity(intent, PackageManager.ResolveInfoFlags.of((long)0L));
            if (resolveInfo == null) return false;
            return true;
        }
        welcomeMessageHelperApiImp = activity.getPackageManager();
        if (welcomeMessageHelperApiImp == null) return false;
        ResolveInfo resolveInfo = welcomeMessageHelperApiImp.resolveActivity(intent, 0);
        if (resolveInfo == null) return false;
        return true;
    }

    private final void reportOnBoardingError(int n) {
        ActivityNotFoundException activityNotFoundException;
        Object object = "Failed to show welcome message with state: " + n + "\ndue to error at: ";
        ActivityNotFoundException activityNotFoundException2 = activityNotFoundException;
        object = new StringBuilder().append((String)object).append('\n');
        String string2 = new ActivityNotFoundException("OnboardingActivity").getMessage();
        if (string2 == null) {
            string2 = "";
        }
        IBGDiagnostics.reportNonFatal((Throwable)activityNotFoundException2, (String)((StringBuilder)object).append(string2).toString());
    }

    private static final void showIntroMessage$lambda$0(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp) {
        Intrinsics.checkNotNullParameter((Object)welcomeMessageHelperApiImp, (String)"this$0");
        InstabugInvocationEvent[] instabugInvocationEventArray = InvocationManager.getInstance().getCurrentInstabugInvocationEvents();
        if (BugSettings.getInstance().getWelcomeMessageState() != 2 && instabugInvocationEventArray != null && instabugInvocationEventArray.length != 0 && welcomeMessageHelperApiImp.isCurrentInvocationEventNotNone()) {
            InstabugSDKLogger.v((String)"IBG-BR", (String)("get welcome message " + BugSettings.getInstance().getWelcomeMessageState()));
            welcomeMessageHelperApiImp.showWelcomeMessage(BugSettings.getInstance().getWelcomeMessageState());
        }
    }

    private static final void showWelcomeMessage$lambda$2(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp, int n, IBGSdkCoreEvent iBGSdkCoreEvent) {
        IBGSdkCoreEvent iBGSdkCoreEvent2 = iBGSdkCoreEvent;
        Intrinsics.checkNotNullParameter((Object)welcomeMessageHelperApiImp, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent2, (String)"ibgSdkCoreEvent");
        if (Intrinsics.areEqual((Object)iBGSdkCoreEvent2.getType(), (Object)"session")) {
            if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.Session.SessionStarted && !InstabugCore.isForegroundBusy()) {
                welcomeMessageHelperApiImp.openOnBoardingActivity(n);
            }
            welcomeMessageHelperApiImp.unsubscribeFromIBGWelcomeMessageEvents();
        }
    }

    private static final void showWelcomeMessage$lambda$3(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp, int n, IBGSdkCoreEvent iBGSdkCoreEvent) {
        Intrinsics.checkNotNullParameter((Object)welcomeMessageHelperApiImp, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent, (String)"coreEvent");
        welcomeMessageHelperApiImp.handleCoreEvents(n, iBGSdkCoreEvent);
    }

    private static final void handleCoreEvents$lambda$4(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp, int n) {
        WelcomeMessageHelperApiImp welcomeMessageHelperApiImp2 = welcomeMessageHelperApiImp;
        Intrinsics.checkNotNullParameter((Object)welcomeMessageHelperApiImp2, (String)"this$0");
        welcomeMessageHelperApiImp2.handleForegroundAvailable(n);
    }

    private static final void handleForegroundAvailable$lambda$5(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp, int n) {
        WelcomeMessageHelperApiImp welcomeMessageHelperApiImp2 = welcomeMessageHelperApiImp;
        Intrinsics.checkNotNullParameter((Object)welcomeMessageHelperApiImp2, (String)"this$0");
        welcomeMessageHelperApiImp2.openOnBoardingActivity(n);
    }

    public static final /* synthetic */ boolean access$resolveActivity(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp, Activity activity, Intent intent) {
        return welcomeMessageHelperApiImp.resolveActivity(activity, intent);
    }

    public static final /* synthetic */ void access$reportOnBoardingError(WelcomeMessageHelperApiImp welcomeMessageHelperApiImp, int n) {
        welcomeMessageHelperApiImp.reportOnBoardingError(n);
    }

    @Override
    public void showIntroMessage() {
        boolean bl = SettingsManager.getInstance().shouldAutoShowOnboarding();
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Checking if should show welcome message, \nShould show " + bl + ", \nWelcome message state " + BugSettings.getInstance().getWelcomeMessageState()));
        if (bl) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                looper = Looper.getMainLooper();
            }
            new Handler(looper).postDelayed(() -> WelcomeMessageHelperApiImp.showIntroMessage$lambda$0(this), 10000L);
        }
    }

    public boolean isCurrentInvocationEventNotNone() {
        InstabugInvocationEvent[] instabugInvocationEventArray = InvocationManager.getInstance().getCurrentInstabugInvocationEvents();
        return instabugInvocationEventArray != null && (instabugInvocationEventArray.length != 1 || instabugInvocationEventArray[0] != InstabugInvocationEvent.NONE);
    }

    public void openOnBoardingActivity(int n) {
        PresentationManager presentationManager = PresentationManager.getInstance();
        if (presentationManager != null) {
            presentationManager.show(this.openOnBoardingRunnable(n));
        }
    }

    @Override
    public void showWelcomeMessage(int n) {
        if (!Instabug.isEnabled()) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Cannot show intro message while SDK is Disabled");
            return;
        }
        if (n == 2) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Cannot show onboarding message while WelcomeMessageState is DISABLED");
            return;
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = InvocationManager.getInstance().getCurrentInstabugInvocationEvents();
        if (instabugInvocationEventArray != null && instabugInvocationEventArray.length != 0 && this.isCurrentInvocationEventNotNone()) {
            if (!InstabugCore.isAppOnForeground() && this.welcomeMessageIBGDisposable == null) {
                this.welcomeMessageIBGDisposable = IBGCoreEventSubscriber.subscribe(arg_0 -> WelcomeMessageHelperApiImp.showWelcomeMessage$lambda$2(this, n, arg_0));
            } else if (InstabugCore.isForegroundNotBusy()) {
                this.openOnBoardingActivity(n);
            } else if (this.welcomeMessageIBGDisposable == null) {
                this.welcomeMessageIBGDisposable = IBGCoreEventSubscriber.subscribe(arg_0 -> WelcomeMessageHelperApiImp.showWelcomeMessage$lambda$3(this, n, arg_0));
            }
            return;
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)"Cannot show onboarding message while invocation event is NONE");
    }

    public void handleCoreEvents(int n, @Nullable IBGSdkCoreEvent iBGSdkCoreEvent) {
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.ForegroundAvailable) {
            PoolProvider.postDelayedTask(() -> WelcomeMessageHelperApiImp.handleCoreEvents$lambda$4(this, n), (long)1000L);
        }
    }

    public void handleForegroundAvailable(int n) {
        if (InstabugCore.isForegroundBusy()) {
            return;
        }
        WelcomeMessageHelperApiImp welcomeMessageHelperApiImp = this;
        PoolProvider.postMainThreadTask(() -> WelcomeMessageHelperApiImp.handleForegroundAvailable$lambda$5(welcomeMessageHelperApiImp, n));
        welcomeMessageHelperApiImp.unsubscribeFromIBGWelcomeMessageEvents();
    }

    public void unsubscribeFromIBGWelcomeMessageEvents() {
        IBGDisposable iBGDisposable = this.welcomeMessageIBGDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
        }
        this.welcomeMessageIBGDisposable = null;
    }
}

