/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.onboardingbugreporting;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.graphics.ColorUtils;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.instabug.bug.R;
import com.instabug.bug.onboardingbugreporting.GenericPagerAdapter;
import com.instabug.bug.onboardingbugreporting.OnBoardingActivityContract$View;
import com.instabug.bug.onboardingbugreporting.OnBoardingPresenter;
import com.instabug.bug.onboardingbugreporting.OnboardingPagerFragment;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseFragmentActivity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugViewPager;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.view.pagerindicator.DotIndicator;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class OnboardingActivity
extends BaseFragmentActivity<OnBoardingPresenter>
implements OnBoardingActivityContract$View,
ViewPager.OnPageChangeListener,
View.OnClickListener {
    @Nullable
    private InstabugViewPager viewPager;
    @Nullable
    private GenericPagerAdapter adapter;
    @Nullable
    private DotIndicator viewPagerIndicator;
    @Nullable
    private Button doneButton;
    @Nullable
    int state;

    public static Intent getIntent(Context context, int n) {
        Intent intent = new Intent(context, OnboardingActivity.class);
        intent.putExtra("welcome_state", n);
        return intent;
    }

    private void handleVisibility() {
        Object object = this.doneButton;
        if (object != null) {
            object.setVisibility(8);
        }
        if (this.viewPagerIndicator != null) {
            object = this.adapter;
            if (object != null && object.getCount() > 1) {
                this.viewPagerIndicator.setVisibility(0);
            } else {
                this.viewPagerIndicator.setVisibility(8);
            }
        }
    }

    protected int getLayout() {
        return R.layout.ib_bg_onboarding_container_activity;
    }

    public void onCreate(@Nullable Bundle bundle) {
        SettingsManager.getInstance().setOnboardingShowing(true);
        SettingsManager.getInstance().setShouldAutoShowOnboarding(false);
        this.presenter = new OnBoardingPresenter(this);
        Serializable serializable = Build.VERSION.SDK_INT >= 33 ? this.getIntent().getSerializableExtra("welcome_state", Serializable.class) : this.getIntent().getSerializableExtra("welcome_state");
        if (serializable != null) {
            this.state = (Integer)serializable;
        }
        OnboardingActivity onboardingActivity = this;
        onboardingActivity.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        super.onCreate(bundle);
        StatusBarUtils.setStatusBarColorForPrompt((Activity)onboardingActivity);
    }

    protected void initViews() {
        DotIndicator dotIndicator;
        Button button;
        InstabugViewPager instabugViewPager;
        this.viewPager = instabugViewPager = (InstabugViewPager)this.findViewById(R.id.ib_bg_onboarding_viewpager);
        if (instabugViewPager != null) {
            InstabugViewPager instabugViewPager2 = instabugViewPager;
            DrawableUtils.setColor((View)instabugViewPager, (int)AttrResolver.getColor((Context)this, (int)R.attr.instabug_background_color));
            instabugViewPager2.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            instabugViewPager2.setOffscreenPageLimit(2);
            instabugViewPager2.setAutoHeight(true);
        }
        this.doneButton = button = (Button)this.findViewById(R.id.ib_bg_onboarding_done);
        if (button != null) {
            Button button2 = button;
            button2.setOnClickListener((View.OnClickListener)this);
            button2.setTextColor(SettingsManager.getInstance().getPrimaryColor());
        }
        this.viewPagerIndicator = dotIndicator = (DotIndicator)this.findViewById(R.id.ib_bg_onboarding_viewpager_indicator);
        if (dotIndicator != null) {
            dotIndicator.setSelectedDotColor(SettingsManager.getInstance().getPrimaryColor());
            this.viewPagerIndicator.setUnselectedDotColor(ColorUtils.setAlphaComponent((int)SettingsManager.getInstance().getPrimaryColor(), (int)80));
        }
        if (instabugViewPager != null && button != null) {
            if (LocaleUtils.isRTL((Locale)InstabugCore.getLocale((Context)this))) {
                Button button3 = button;
                instabugViewPager.setRotation(180.0f);
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)button3.getLayoutParams();
                layoutParams.addRule(5, instabugViewPager.getId());
                button3.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            } else {
                Button button4 = button;
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)button4.getLayoutParams();
                layoutParams.addRule(7, instabugViewPager.getId());
                button4.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        if ((instabugViewPager = this.presenter) != null) {
            ((OnBoardingPresenter)instabugViewPager).start(this.state);
        }
    }

    @Override
    public void loadViewPager(List<OnboardingPagerFragment> instabugViewPager) {
        GenericPagerAdapter genericPagerAdapter;
        GenericPagerAdapter genericPagerAdapter2 = genericPagerAdapter;
        this.adapter = new GenericPagerAdapter(this.getSupportFragmentManager(), (List<OnboardingPagerFragment>)instabugViewPager);
        instabugViewPager = this.viewPager;
        if (instabugViewPager != null) {
            instabugViewPager.setAdapter((PagerAdapter)genericPagerAdapter2);
        }
        if ((instabugViewPager = this.viewPagerIndicator) != null) {
            instabugViewPager.setNumberOfItems(this.adapter.getCount());
        }
        this.handleVisibility();
    }

    public void onPageScrolled(int n, float f, int n2) {
    }

    public void onPageSelected(int n) {
        Object object = this.viewPagerIndicator;
        if (object != null) {
            object.setSelectedItem(n, true);
        }
        if (this.doneButton != null) {
            object = this.adapter;
            if (object != null && n == object.getCount() - 1 && this.adapter.getCount() > 1) {
                OnboardingActivity onboardingActivity = this;
                onboardingActivity.doneButton.setVisibility(0);
                onboardingActivity.doneButton.requestFocus();
            } else {
                OnboardingActivity onboardingActivity = this;
                onboardingActivity.doneButton.setVisibility(4);
                onboardingActivity.doneButton.requestFocus(0);
            }
        }
    }

    public void onPageScrollStateChanged(int n) {
    }

    public void onClick(View view) {
        if (view.getId() == R.id.ib_bg_onboarding_done || view.getId() == R.id.ib_bg_onboarding_container) {
            this.finish();
        }
    }

    public void onBackPressed() {
        OnboardingActivity onboardingActivity = this;
        super.onBackPressed();
        onboardingActivity.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
    }

    @Override
    public void dismiss() {
        this.finish();
    }

    @Override
    public void handlePowerByInstabugFooter() {
        InstabugCore.handlePbiFooter((View)this.findViewById(0x1020002).getRootView());
    }

    public void finish() {
        OnboardingActivity onboardingActivity = this;
        super.finish();
        onboardingActivity.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        SettingsManager.getInstance().setOnboardingShowing(false);
    }

    @Override
    public void enableClickToClose() {
        this.findViewById(R.id.ib_bg_onboarding_container).setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public String getLocalizedString(@StringRes int n) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this), (int)n, (Context)this);
    }
}

