/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.bug.model.Bug;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.utils.DeleteBugsUtilKt;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.featuresflags.EnhancementRequestBodyParams;
import com.instabug.library.featuresflags.di.FeaturesFlagServiceLocator;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestExtKt;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class BugsService {
    @Nullable
    private static BugsService INSTANCE;
    @VisibleForTesting
    Request reportingBugRequest;
    private final NetworkManager networkManager = NetworkManager.newInstance();

    @VisibleForTesting
    private BugsService() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BugsService getInstance() {
        String string2 = BugsService.class.getName();
        synchronized (string2) {
            Throwable throwable2;
            block4: {
                block3: {
                    try {
                        if (INSTANCE != null) break block3;
                        INSTANCE = new BugsService();
                    }
                    catch (Throwable throwable2) {
                        break block4;
                    }
                }
                return INSTANCE;
            }
            throw throwable2;
        }
    }

    @Nullable
    private RequestParameter<String> getFrustratingExperienceExternalIdRequestParameter(Bug bug) {
        if (bug.getFrustratingExperienceExternalId() != null && bug.getCategories().contains("Force restarts")) {
            return new RequestParameter("force_restart_token", (Object)bug.getFrustratingExperienceExternalId());
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateReportedAtIfNeeded(Request.Builder object, Bug bug) {
        Exception exception2;
        block4: {
            RequestParameter requestParameter;
            long l;
            BugsService bugsService = bug.getState();
            if (bugsService != null && !bugsService.isMinimalState() && bugsService.getReportedAt() != 0L) {
                return;
            }
            try {
                l = bug.getId() != null ? Long.parseLong(bug.getId()) : 0L;
            }
            catch (Exception exception2) {
                break block4;
            }
            if (l == 0L) return;
            Request.Builder builder = object;
            bugsService = requestParameter;
            {
                object = "reported_at";
                requestParameter = new RequestParameter((String)object, (Object)l);
                builder.addParameter((RequestParameter)bugsService);
            }
            return;
        }
        IBGDiagnostics.reportNonFatal((Throwable)exception2, (String)"Failed to update reported_at in bug reporting request.");
    }

    public void reportBug(final Context context, Bug bug, final Request.Callbacks<String, Throwable> callbacks) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        BugsService bugsService = this;
        InstabugSDKLogger.d((String)"IBG-BR", (String)"Reporting bug request started");
        bug = bugsService.buildBugReportingRequest(bug);
        bugsService.reportingBugRequest = bug;
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

            public void onSucceeded(RequestResponse requestResponse) {
                block4: {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("ReportingBugRequest succeeded, Response code: " + requestResponse.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("Response body: " + requestResponse.getResponseBody()));
                    if (requestResponse.getResponseBody() == null) break block4;
                    try {
                        calendar.callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                    }
                    catch (JSONException jSONException) {
                        InstabugCore.reportError((Throwable)jSONException, (String)("Reporting bug got an error: " + jSONException.getMessage()));
                        InstabugSDKLogger.e((String)"IBG-BR", (String)("reportingBugRequest got error: " + jSONException.getMessage()), (Throwable)jSONException);
                        calendar.callbacks.onFailed((Object)jSONException);
                    }
                }
                if (requestResponse.getResponseCode() == 200) {
                    Intent intent;
                    1 v0 = calendar;
                    Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("Updating last_contacted_at to " + calendar.getTime()));
                    BugSettings.getInstance().setLastBugTime(calendar.getTime().getTime());
                    InstabugCore.setLastContactedAt((long)calendar.getTime().getTime());
                    RequestResponse requestResponse2 = requestResponse = intent;
                    requestResponse2();
                    requestResponse2.setAction("User last contact at changed");
                    long l = calendar.getTime().getTime();
                    intent.putExtra("last_contacted_at", l);
                    LocalBroadcastManager.getInstance((Context)v0.context).sendBroadcast((Intent)requestResponse);
                }
            }

            public void onFailed(Throwable throwable) {
                if (throwable instanceof RateLimitedException) {
                    callbacks.onFailed((Object)throwable);
                    return;
                }
                InstabugCore.reportError((Throwable)throwable, (String)("Reporting bug got an error: " + throwable.getMessage()));
                InstabugSDKLogger.e((String)"IBG-BR", (String)("reportingBugRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }

            public void onDisconnected() {
                callbacks.onDisconnected();
            }

            public void onRetrying(Throwable throwable) {
                callbacks.onRetrying(throwable);
            }
        };
        bugsService.networkManager.doRequestOnSameThread(1, (Request)bug, (Request.Callbacks)callbacks3);
    }

    @VisibleForTesting
    Request buildBugReportingRequest(Bug bug) {
        RequestParameter requestParameter;
        Request.Builder builder = new Request.Builder().endpoint("/bugs").method("POST");
        RequestExtKt.getTokenFromState((Request.Builder)builder, (State)bug.getState());
        builder.addParameter(new RequestParameter("title", (Object)bug.getMessage()));
        builder.addParameter(new RequestParameter("attachments_count", (Object)bug.getAttachments().size()));
        builder.addParameter(new RequestParameter("categories", (Object)bug.getCategoriesString()));
        if (bug.getConnectionError() != null) {
            builder.addParameter(new RequestParameter("connection_delay_reported_at", (Object)InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds()));
        }
        if (bug.getActionableConsentsAsJsonArray().length() > 0) {
            RequestParameter requestParameter2;
            requestParameter = requestParameter2;
            requestParameter2 = new RequestParameter("actionable_consents", (Object)bug.getActionableConsentsAsJsonArray());
            builder.addParameter(requestParameter);
        }
        if ((requestParameter = this.getFrustratingExperienceExternalIdRequestParameter(bug)) != null) {
            builder.addParameter(requestParameter);
        }
        this.reportingBugRequest = this.addStateItemsToRequestBodyParameters(builder, bug);
        return this.reportingBugRequest;
    }

    @VisibleForTesting
    Request addStateItemsToRequestBodyParameters(Request.Builder builder, Bug bug) {
        if (bug.getState() != null) {
            Iterator iterator = new EnhancementRequestBodyParams().getModifiedStateItemsList(bug.getState().getStateItems(), FeaturesFlagServiceLocator.getFeaturesFlagsConfigsProvider().getMode()).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String object = (String)entry2.getKey();
                builder.addParameter(new RequestParameter(object, entry2.getValue()));
            }
        }
        this.updateReportedAtIfNeeded(builder, bug);
        return builder.build();
    }

    public void uploadBugAttachments(final Bug bug, final Request.Callbacks<Boolean, Throwable> callbacks) {
        ArrayList arrayList;
        InstabugSDKLogger.d((String)"IBG-BR", (String)"Uploading Bug attachments");
        if (bug.getAttachments().isEmpty()) {
            callbacks.onSucceeded((Object)Boolean.TRUE);
            return;
        }
        final ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (int i = 0; i < bug.getAttachments().size(); ++i) {
            File file;
            final Attachment attachment = bug.getAttachments().get(i);
            boolean bl = AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment);
            if (attachment.getLocalPath() == null || attachment.getName() == null) continue;
            Object object = file;
            file = new File(attachment.getLocalPath());
            if (bl && ((File)object).exists() && ((File)object).length() > 0L) {
                Request.Callbacks<RequestResponse, Throwable> callbacks2;
                Object object2 = new Request.Builder().endpoint("/bugs/:bug_token/attachments").method("POST").type(2);
                RequestExtKt.getTokenFromState((Request.Builder)object2, (State)bug.getState());
                if (bug.getTemporaryServerToken() != null) {
                    object = bug.getTemporaryServerToken();
                    object2.endpoint("/bugs/:bug_token/attachments".replaceAll(":bug_token", (String)object));
                }
                if (attachment.getType() != null) {
                    object2.addParameter(new RequestParameter("metadata[file_type]", (Object)attachment.getType()));
                    if (attachment.getType() == Attachment.Type.AUDIO && attachment.getDuration() != null) {
                        RequestParameter requestParameter;
                        object = requestParameter;
                        requestParameter = new RequestParameter("metadata[duration]", (Object)attachment.getDuration());
                        object2.addParameter((RequestParameter)object);
                    }
                }
                attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
                Attachment attachment2 = attachment;
                object = attachment2.getName();
                String string2 = attachment2.getLocalPath();
                String string3 = attachment2.getFileType();
                object2.fileToUpload(new FileToUpload("file", (String)object, string2, string3));
                Request request = object2.build();
                object2 = callbacks2;
                callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

                    public void onSucceeded(RequestResponse requestResponse) {
                        InstabugSDKLogger.d((String)"IBG-BR", (String)("uploadingBugAttachmentRequest succeeded, Response code: " + requestResponse.getResponseCode()));
                        InstabugSDKLogger.v((String)"IBG-BR", (String)("uploadingBugAttachmentRequest succeeded, Response body: " + requestResponse.getResponseCode() + requestResponse.getResponseBody()));
                        if (attachment.getLocalPath() != null) {
                            2 v0 = this;
                            DeleteBugsUtilKt.deleteAttachment(v0.attachment, bug.getId());
                            v0.arrayList2.add(attachment);
                        }
                        if (arrayList2.size() == bug.getAttachments().size()) {
                            callbacks.onSucceeded((Object)Boolean.TRUE);
                        }
                    }

                    public void onFailed(Throwable throwable) {
                        2 v0 = this;
                        InstabugSDKLogger.e((String)"IBG-BR", (String)("uploadingBugAttachmentRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                        AttachmentsUtility.encryptAttachmentAndUpdateDb((Attachment)v0.attachment);
                        v0.callbacks.onFailed((Object)throwable);
                        if (throwable instanceof IOException) {
                            bug.getAttachments().clear();
                        }
                    }
                };
                this.networkManager.doRequestOnSameThread(2, request, (Request.Callbacks)object2);
                continue;
            }
            if (!bl) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Skipping attachment file of type " + attachment.getType() + " because it was not decrypted successfully"));
                continue;
            }
            if (((File)object).exists() && ((File)object).length() > 0L) continue;
            InstabugSDKLogger.e((String)"IBG-BR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
        }
    }

    public void uploadBugLogs(Bug bug, final Request.Callbacks<Boolean, Throwable> callbacks) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        BugsService bugsService = this;
        InstabugSDKLogger.v((String)"IBG-BR", (String)"Uploading bug logs request started");
        try {
            bug = bugsService.buildBugLogsRequest(bug);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"uploading bug logs got Json error ", (Throwable)exception);
            callbacks.onFailed((Object)exception);
            return;
        }
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(){

            public void onSucceeded(RequestResponse requestResponse) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("uploading bug logs succeeded, Response code: " + requestResponse.getResponseCode()));
                InstabugSDKLogger.v((String)"IBG-BR", (String)("uploading bug logs onNext, Response body: " + requestResponse.getResponseBody()));
                callbacks.onSucceeded((Object)Boolean.TRUE);
            }

            public void onFailed(Throwable throwable) {
                InstabugCore.reportError((Throwable)throwable, (String)("uploading bug logs got error: " + throwable.getMessage()));
                InstabugSDKLogger.e((String)"IBG-BR", (String)"uploading bug logs got error", (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }
        };
        bugsService.networkManager.doRequestOnSameThread(1, (Request)bug, (Request.Callbacks)callbacks3);
    }

    @VisibleForTesting
    Request buildBugLogsRequest(Bug bug) {
        Object object;
        BugsService bugsService = new Request.Builder().endpoint("/bugs/:bug_token/state_logs").method("POST");
        RequestExtKt.getTokenFromState((Request.Builder)bugsService, (State)bug.getState());
        if (bug.getTemporaryServerToken() != null) {
            object = bug.getTemporaryServerToken();
            bugsService.endpoint("/bugs/:bug_token/state_logs".replaceAll(":bug_token", (String)object));
        }
        if ((object = bug.getState() != null ? bug.getState().getLogsItems() : null) != null) {
            for (Object object2 : object) {
                RequestParameter requestParameter;
                if (object2.getKey() == null || object2.getValue() == null) continue;
                RequestParameter requestParameter2 = requestParameter;
                State.StateItem stateItem = object2;
                object2 = stateItem.getKey();
                requestParameter = new RequestParameter((String)object2, stateItem.getValue());
                bugsService.addParameter(requestParameter2);
            }
        }
        if (bug.getViewHierarchy() != null) {
            RequestParameter requestParameter;
            object = requestParameter;
            requestParameter = new RequestParameter("view_hierarchy", (Object)bug.getViewHierarchy());
            bugsService.addParameter((RequestParameter)object);
        }
        return bugsService.build();
    }
}

