/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invocationdialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivityContract$View;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.bug.invocation.invoker.ShakeInvoker;
import com.instabug.library.Instabug;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.core.plugin.PromptOptionManager;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DeleteUriDiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;

public class InstabugDialogActivityPresenter
extends BasePresenter<InstabugDialogActivityContract$View>
implements BaseContract.Presenter {
    private final InstabugDialogActivityContract$View viewInstance;
    @Nullable
    private InstabugDialogItem selectedItem;
    @Nullable
    private Handler autoDismissHandler;
    private int enterAnimation;
    private int exitAnimation;

    InstabugDialogActivityPresenter(InstabugDialogActivityContract$View instabugDialogActivityContract$View) {
        super((BaseContract.View)instabugDialogActivityContract$View);
        this.viewInstance = instabugDialogActivityContract$View;
        this.enterAnimation = instabugDialogActivityContract$View.getFadeInAnimation();
        this.exitAnimation = instabugDialogActivityContract$View.getSlidOutLeftAnimation();
        SettingsManager.getInstance().setProcessingForeground(false);
    }

    private void startAutoDismiss() {
        Handler handler;
        Object object = handler;
        this.autoDismissHandler = new Handler();
        if (this.viewInstance != null) {
            Runnable runnable;
            Handler handler2 = object;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    InstabugDialogActivityPresenter.this.viewInstance.finishActivity();
                }
            };
            handler2.postDelayed((Runnable)object, 10000L);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void cancelAutoDismiss() {
        InstabugDialogActivityPresenter instabugDialogActivityPresenter = instabugDialogActivityPresenter.autoDismissHandler;
        if (instabugDialogActivityPresenter != null) {
            instabugDialogActivityPresenter.removeCallbacksAndMessages(null);
        }
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    private void invoke(InstabugDialogItem instabugDialogItem2, @Nullable Uri uri) {
        PluginPromptOption pluginPromptOption = InvocationManager.getInstance().getAvailablePromptOptions();
        if (((InstabugDialogActivityPresenter)((Object)this)).getRootParent(instabugDialogItem2).getOrder() == -1) {
            for (InstabugDialogItem instabugDialogItem2 : pluginPromptOption) {
                if (instabugDialogItem2.getOrder() != -1) continue;
                instabugDialogItem2.invoke();
                break;
            }
        } else {
            pluginPromptOption = PromptOptionManager.getPluginByIdentifier((int)instabugDialogItem2.getIdentifier(), (boolean)true);
            if (pluginPromptOption != null) {
                pluginPromptOption.invoke(uri, super.getCategories(instabugDialogItem2));
            }
        }
    }

    private String[] getCategories(InstabugDialogItem instabugDialogItem) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (instabugDialogItem.getParent() != null) {
            arrayList2.add(instabugDialogItem.getTitle());
            instabugDialogItem = instabugDialogItem.getParent();
        }
        ArrayList arrayList3 = arrayList2;
        Collections.reverse(arrayList3);
        return arrayList3.toArray(new String[0]);
    }

    private InstabugDialogItem getRootParent(InstabugDialogItem instabugDialogItem) {
        while (instabugDialogItem.getParent() != null) {
            instabugDialogItem = instabugDialogItem.getParent();
        }
        return instabugDialogItem;
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void onViewStarted() {
        if (InvocationManager.getInstance().getLastUsedInvoker() instanceof ShakeInvoker) {
            this.startAutoDismiss();
        }
    }

    public void onViewStopped() {
        this.cancelAutoDismiss();
        SettingsManager.getInstance().setShouldAutoShowOnboarding(false);
    }

    public void onItemClicked(@Nullable InstabugDialogItem object, @Nullable Uri uri) {
        this.selectedItem = object;
        this.cancelAutoDismiss();
        if (object != null) {
            ArrayList<InstabugDialogItem> arrayList = ((InstabugDialogItem)object).getSubItems();
            if (arrayList != null && !arrayList.isEmpty()) {
                InstabugDialogActivityPresenter instabugDialogActivityPresenter = this;
                instabugDialogActivityPresenter.enterAnimation = instabugDialogActivityPresenter.viewInstance.getSlidInRightAnimation();
                instabugDialogActivityPresenter.exitAnimation = instabugDialogActivityPresenter.viewInstance.getSlidOutLeftAnimation();
                if ((object = this.getRootParent((InstabugDialogItem)object).getTitle()) == null) {
                    object = "";
                }
                this.viewInstance.setContent((String)object, false, arrayList);
            } else {
                this.invoke((InstabugDialogItem)object, uri);
            }
        }
    }

    public int getContentEnterAnimation() {
        return this.enterAnimation;
    }

    public int getContentExitAnimation() {
        return this.exitAnimation;
    }

    public void onBackPressed() {
        InstabugDialogItem instabugDialogItem = this.selectedItem;
        if (instabugDialogItem != null) {
            this.selectedItem = instabugDialogItem.getParent();
        }
        InstabugDialogActivityPresenter instabugDialogActivityPresenter = this;
        instabugDialogActivityPresenter.enterAnimation = instabugDialogActivityPresenter.viewInstance.getSlidInLeftAnimation();
        instabugDialogActivityPresenter.exitAnimation = instabugDialogActivityPresenter.viewInstance.getSlidOutRightAnimation();
    }

    public void resetPromptOptionsSelection() {
        this.selectedItem = null;
    }

    public boolean isPromptOptionSelected() {
        return this.selectedItem != null;
    }

    public void dumpAttachments(Uri ... uriArray) {
        InstabugDialogActivityPresenter instabugDialogActivityPresenter = Instabug.getApplicationContext();
        if (instabugDialogActivityPresenter != null) {
            instabugDialogActivityPresenter = DiskUtils.with((Context)instabugDialogActivityPresenter);
            if (uriArray != null) {
                for (Uri uri : uriArray) {
                    instabugDialogActivityPresenter.deleteOperation((DiskOperation)new DeleteUriDiskOperation(uri)).executeAsync(null);
                }
            }
        } else {
            InstabugSDKLogger.e((String)"IBG-Core", (String)"Can't execute dumpAttachments() due to null context");
        }
    }

    void removeScreenShotIfNeeded(InstabugDialogItem instabugDialogItem) {
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (InstabugDialogActivityContract$View)((Reference)object).get()) != null && instabugDialogItem != null && !instabugDialogItem.isInitialScreenshotRequired()) {
            object.onInitialScreenShotNotRequired();
        }
    }
}

