/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invocationdialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.instabug.bug.R;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivityContract$AnimationProvider;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivityContract$View;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivityPresenter;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogFragment;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.library.Instabug;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.InstabugDialogActivityBase;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.util.StatusBarUtils;
import java.util.ArrayList;
import java.util.Locale;

public class InstabugDialogActivity
extends InstabugDialogActivityBase<InstabugDialogActivityPresenter>
implements InstabugDialogFragment.Callbacks,
InstabugDialogActivityContract$View,
View.OnClickListener,
InstabugDialogActivityContract$AnimationProvider {
    private static Locale currentDialogLocale;
    @Nullable
    private View[] sharedViews;
    private boolean shouldBeKilled = false;
    @Nullable
    private Uri screenshotUri;
    @Nullable
    private ArrayList<InstabugDialogItem> dialogItems;
    private boolean isInflated = false;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static Intent getIntent(Context context, @Nullable String string2, @Nullable Uri uri, @Nullable ArrayList<InstabugDialogItem> arrayList, boolean bl) {
        Intent intent = new Intent(context, InstabugDialogActivity.class);
        intent.putExtra("dialog_title", string2);
        intent.putExtra("screenshot_uri", (Parcelable)uri);
        intent.putExtra("dialog_items", arrayList);
        intent.putExtra("should_be_killed", bl);
        intent.addFlags(0x10000000);
        return intent;
    }

    private InstabugDialogActivityPresenter createPresenter() {
        return new InstabugDialogActivityPresenter(this);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    private void runOnSdkInvokedRunnable() {
        if (SettingsManager.getInstance().getOnSdkInvokedCallback() != null) {
            SettingsManager.getInstance().getOnSdkInvokedCallback().onSdkInvoked();
        }
    }

    private boolean areDialogItemsTheSame(@Nullable ArrayList<InstabugDialogItem> arrayList) {
        ArrayList<InstabugDialogItem> arrayList2 = ((InstabugDialogActivity)((Object)arrayList2)).dialogItems;
        if (arrayList2 != null) {
            return arrayList2.equals(arrayList);
        }
        return arrayList == null;
    }

    public AppCompatActivity getViewContext() {
        return null;
    }

    public void finishActivity() {
    }

    public void onCreate(@Nullable Bundle bundle) {
        InstabugDialogActivity instabugDialogActivity = this;
        this.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        super.onCreate(bundle);
        StatusBarUtils.setStatusBarColorForPrompt((Activity)instabugDialogActivity);
        if (ScreenUtility.hasNavBar((Context)instabugDialogActivity) && !ScreenUtility.isLandscape((Activity)this) && (bundle = (FrameLayout)this.findViewById(R.id.ib_fragment_container)) != null) {
            Bundle bundle2 = bundle;
            int n = bundle2.getPaddingLeft();
            int n2 = bundle2.getPaddingTop();
            int n3 = bundle2.getPaddingRight();
            int n4 = bundle.getPaddingBottom() + ScreenUtility.getNavigationBarHeight((Resources)this.getResources());
            bundle2.setPadding(n, n2, n3, n4);
        }
        InstabugDialogActivity instabugDialogActivity2 = this;
        instabugDialogActivity2.screenshotUri = (Uri)instabugDialogActivity2.getIntent().getParcelableExtra("screenshot_uri");
        instabugDialogActivity2.runOnSdkInvokedRunnable();
        instabugDialogActivity2.setTitle(" ");
    }

    protected void onNewIntent(Intent intent) {
        InstabugDialogActivity instabugDialogActivity = this;
        super.onNewIntent(intent);
        String string2 = instabugDialogActivity.getIntent().getStringExtra("dialog_title");
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("dialog_items");
        if (this.areDialogItemsTheSame(arrayList)) {
            return;
        }
        this.setIntent(intent);
        if (arrayList == null) {
            this.finish();
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.setContent(string2, true, arrayList);
        if (intent.getBooleanExtra("should_be_killed", false)) {
            this.shouldBeKilled = true;
        }
    }

    protected int getLayout() {
        return R.layout.ib_lyt_activity_dialog;
    }

    protected void initViews() {
        if (this.presenter == null) {
            this.presenter = this.createPresenter();
        }
        if (this.getIntent().getSerializableExtra("dialog_items") == null) {
            this.finish();
            return;
        }
        InstabugDialogActivity instabugDialogActivity = this;
        instabugDialogActivity.findViewById(R.id.ib_fragment_container).setOnClickListener((View.OnClickListener)this);
        instabugDialogActivity.findViewById(R.id.ib_dialog_container).setOnClickListener((View.OnClickListener)this);
        if (instabugDialogActivity.getIntent().getBooleanExtra("should_be_killed", false)) {
            this.shouldBeKilled = true;
        }
        if (this.dialogItems == null) {
            this.dialogItems = (ArrayList)this.getIntent().getSerializableExtra("dialog_items");
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        bundle.putSerializable("dialog_items", this.dialogItems);
        super.onSaveInstanceState(bundle);
    }

    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.dialogItems = (ArrayList)bundle.getSerializable("dialog_items");
    }

    @Override
    public void onDialogItemClicked(@Nullable InstabugDialogItem instabugDialogItem, View ... presenter) {
        this.sharedViews = presenter;
        presenter = this.presenter;
        if (presenter != null) {
            ((InstabugDialogActivityPresenter)presenter).onItemClicked(instabugDialogItem, this.screenshotUri);
        }
        if (this.shouldBeKilled) {
            this.finish();
        }
    }

    @Override
    public void removeScreenshotIfNeeded(InstabugDialogItem instabugDialogItem) {
        InstabugDialogActivity instabugDialogActivity = instabugDialogActivity.presenter;
        if (instabugDialogActivity != null) {
            ((InstabugDialogActivityPresenter)((Object)instabugDialogActivity)).removeScreenShotIfNeeded(instabugDialogItem);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.ib_fragment_container || view.getId() == R.id.ib_dialog_container) {
            view = this.presenter;
            if (view != null) {
                ((InstabugDialogActivityPresenter)view).resetPromptOptionsSelection();
            }
            this.finish();
        }
    }

    public void onBackPressed() {
        InstabugDialogActivity instabugDialogActivity = this;
        instabugDialogActivity.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        BaseContract.Presenter presenter = instabugDialogActivity.presenter;
        if (presenter != null) {
            ((InstabugDialogActivityPresenter)presenter).onBackPressed();
        }
        super.onBackPressed();
    }

    public void finish() {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null && !((InstabugDialogActivityPresenter)presenter).isPromptOptionSelected() && (presenter = SettingsManager.getInstance().getOnSdkDismissCallback()) != null) {
            presenter.call(OnSdkDismissCallback.DismissType.CANCEL, OnSdkDismissCallback.ReportType.OTHER);
        }
        InstabugDialogActivity instabugDialogActivity = this;
        super.finish();
        instabugDialogActivity.overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
    }

    public void onStart() {
        InstabugDialogActivity instabugDialogActivity = instabugDialogActivity2;
        super.onStart();
        InstabugDialogActivity instabugDialogActivity2 = instabugDialogActivity.presenter;
        if (instabugDialogActivity2 != null) {
            ((InstabugDialogActivityPresenter)((Object)instabugDialogActivity2)).onViewStarted();
        }
    }

    public void onStop() {
        InstabugDialogActivity instabugDialogActivity = instabugDialogActivity2;
        super.onStop();
        InstabugDialogActivity instabugDialogActivity2 = instabugDialogActivity.presenter;
        if (instabugDialogActivity2 != null) {
            ((InstabugDialogActivityPresenter)((Object)instabugDialogActivity2)).onViewStopped();
        }
    }

    protected void onDestroy() {
        BaseContract.Presenter presenter;
        if (this.isFinishing() && (presenter = this.presenter) != null && !((InstabugDialogActivityPresenter)presenter).isPromptOptionSelected()) {
            presenter = this.screenshotUri;
            ((InstabugDialogActivityPresenter)this.presenter).dumpAttachments(new Uri[]{presenter});
        }
        super.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        if (currentDialogLocale != null && !InstabugCore.getLocale((Context)this).equals(currentDialogLocale)) {
            this.finish();
            Instabug.show();
        }
        if (!this.isInflated) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.ib_fragment_container, (Fragment)InstabugDialogFragment.newInstance(this.getIntent().getStringExtra("dialog_title"), true, this.dialogItems)).commit();
            this.isInflated = true;
        }
        SettingsManager.getInstance().setPromptOptionsScreenShown(true);
    }

    protected void onPause() {
        InstabugDialogActivity instabugDialogActivity = this;
        super.onPause();
        SettingsManager.getInstance().setPromptOptionsScreenShown(false);
        currentDialogLocale = InstabugCore.getLocale((Context)instabugDialogActivity);
    }

    @Override
    public void onInitialScreenShotNotRequired() {
        BaseContract.Presenter presenter = instabugDialogActivity.presenter;
        if (presenter != null) {
            InstabugDialogActivity instabugDialogActivity = instabugDialogActivity.screenshotUri;
            ((InstabugDialogActivityPresenter)presenter).dumpAttachments(new Uri[]{instabugDialogActivity});
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void setContent(@Nullable String string2, boolean bl, ArrayList<InstabugDialogItem> arrayList) {
        FragmentTransaction fragmentTransaction;
        block8: {
            InstabugDialogActivity instabugDialogActivity = this;
            fragmentTransaction = instabugDialogActivity.getSupportFragmentManager().beginTransaction();
            View[] viewArray = instabugDialogActivity.sharedViews;
            if (instabugDialogActivity.sharedViews != null) {
                int n = viewArray.length;
                for (int i = 0; i < n; ++i) {
                    View view = viewArray[i];
                    if (view == null) continue;
                    String string3 = ViewCompat.getTransitionName((View)view);
                    if (string3 == null) continue;
                    fragmentTransaction.addSharedElement(view, string3);
                }
            }
            break block8;
            {
                catch (IllegalArgumentException illegalArgumentException) {
                    break;
                }
            }
        }
        this.dialogItems = arrayList;
        int n = R.id.ib_fragment_container;
        fragmentTransaction.setCustomAnimations(0, R.anim.ib_core_anim_invocation_dialog_exit).addToBackStack(null).replace(n, (Fragment)InstabugDialogFragment.newInstance(string2, bl, arrayList)).commit();
    }

    @Override
    public int getSlidInLeftAnimation() {
        return R.anim.ib_core_anim_slide_in_left;
    }

    @Override
    public int getSlidInRightAnimation() {
        return R.anim.ib_core_anim_slide_in_right;
    }

    @Override
    public int getSlidOutLeftAnimation() {
        return R.anim.ib_core_anim_slide_out_left;
    }

    @Override
    public int getSlidOutRightAnimation() {
        return R.anim.ib_core_anim_slide_out_right;
    }

    @Override
    public int getFadeInAnimation() {
        return R.anim.ib_core_anim_fade_in;
    }

    @Override
    public int getEnterAnimation() {
        InstabugDialogActivity instabugDialogActivity = instabugDialogActivity.presenter;
        if (instabugDialogActivity != null) {
            return ((InstabugDialogActivityPresenter)((Object)instabugDialogActivity)).getContentEnterAnimation();
        }
        return 0;
    }

    @Override
    public int getExitAnimation() {
        InstabugDialogActivity instabugDialogActivity = instabugDialogActivity.presenter;
        if (instabugDialogActivity != null) {
            return ((InstabugDialogActivityPresenter)((Object)instabugDialogActivity)).getContentExitAnimation();
        }
        return 0;
    }
}

