/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video.customencoding;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.customencoding.BaseEncoder;
import com.instabug.bug.internal.video.customencoding.VideoEncodeConfig;
import java.util.Objects;

@TargetApi(value=21)
class VideoEncoder
extends BaseEncoder {
    private VideoEncodeConfig mConfig;
    @Nullable
    private Surface mSurface;

    VideoEncoder(VideoEncodeConfig videoEncodeConfig) {
        super(videoEncodeConfig.getCodecName());
        this.mConfig = videoEncodeConfig;
    }

    @Override
    protected void onEncoderConfigured(MediaCodec mediaCodec) {
        this.mSurface = mediaCodec.createInputSurface();
    }

    @Override
    protected MediaFormat createMediaFormat() {
        return this.mConfig.toFormat();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    Surface getInputSurface() {
        return Objects.requireNonNull(this.mSurface, "doesn't prepare()");
    }

    @Override
    public void release() {
        Surface surface = this.mSurface;
        if (surface != null) {
            surface.release();
            this.mSurface = null;
        }
        super.release();
    }
}

