/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.cache.migrationpolicy;

import android.content.ContentValues;
import com.instabug.bug.cache.BugReportsDbHelper;
import com.instabug.bug.cache.migrationpolicy.MigrationInterruptionPolicy;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.dbv2.migration.MigrationInterruptedException;
import com.instabug.library.util.InstabugSDKLogger;

public class InterTableMigrationInterruptionsPolicy
implements MigrationInterruptionPolicy {
    private final Exception withException;
    private BugReportsDbHelper<ContentValues> bugReportsPlainDbHelper;

    public InterTableMigrationInterruptionsPolicy(Exception exception) {
        InterTableMigrationInterruptionsPolicy interTableMigrationInterruptionsPolicy = this;
        interTableMigrationInterruptionsPolicy.withException = exception;
        interTableMigrationInterruptionsPolicy.bugReportsPlainDbHelper = ServiceLocator.getBugReportsPlainDbHelper();
    }

    @Override
    public void migrate() {
        InterTableMigrationInterruptionsPolicy interTableMigrationInterruptionsPolicy = this;
        interTableMigrationInterruptionsPolicy.bugReportsPlainDbHelper.deleteAll();
        Exception exception = interTableMigrationInterruptionsPolicy.withException;
        InstabugSDKLogger.e((String)"IBG-BR", (String)"Failed to migrate bugs to encrypted DB, dropping them.", (Throwable)exception);
        IBGDiagnostics.reportNonFatal((Throwable)new MigrationInterruptedException(this.withException.getMessage()), (String)"Failed to migrate bugs to encrypted DB, dropping them.");
    }
}

