/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.bug.OnSdkDismissedCallback$DismissType;
import com.instabug.bug.ReportingPluginWrapper;
import com.instabug.bug.StateAction;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.network.NormalBugsUploaderJob;
import com.instabug.bug.network.ProactiveReportsBugsUploaderJob;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.testingreport.ReportUploadingStateEventBus;
import com.instabug.bug.utils.BugUtils;
import com.instabug.bug.utils.DeleteBugsUtilKt;
import com.instabug.chat.synchronization.SynchronizationManager;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.frustratingexperience.FrustratingExperienceEvent;
import com.instabug.library.frustratingexperience.FrustratingExperienceEventBus;
import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserEvent;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.StateKtxKt;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import io.reactivexport.android.schedulers.AndroidSchedulers;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveBugManager {
    private static LiveBugManager instance;
    @Nullable
    private volatile Bug bug;
    private boolean isInBackground;
    private OnSdkDismissedCallback$DismissType dismissType = OnSdkDismissedCallback$DismissType.CANCEL;
    private int recordingDuration = -1;

    private LiveBugManager() {
    }

    public static synchronized LiveBugManager getInstance() {
        if (instance == null) {
            instance = new LiveBugManager();
        }
        return instance;
    }

    private void startStateBuilder(Context context) {
        ActionsOrchestrator.obtainOrchestrator((Executor)PoolProvider.getBugsExecutor()).addWorkerThreadAction((Action)new StateAction(context)).orchestrate();
    }

    @WorkerThread
    private void prepareState(Context context, @NonNull State state) {
        Bug bug = ((LiveBugManager)((Object)file2)).bug;
        if (bug != null) {
            File file;
            LiveBugManager liveBugManager = file2;
            File file2 = file;
            file = new File(bug.getAttachmentsPath() + "/bug_state_" + System.currentTimeMillis() + ".txt");
            state.setUri(DiskUtils.with((Context)context).writeOperation((DiskOperation)new WriteStateToFileDiskOperation(file2, state.toJson())).execute());
            liveBugManager.bug = bug;
        }
    }

    private void saveBugToDB(Bug bug) {
        if (ServiceLocator.getBugReportsDbHelper().insert(bug.setBugState(Bug.BugState.READY_TO_BE_SENT)) != -1L) {
            this.postFrustratingExperienceReportSaved(bug);
        }
    }

    private void triggerSync() {
        if (SynchronizationManager.getInstance() != null) {
            SynchronizationManager.getInstance().sync(false);
        }
    }

    private void setUserAttributes(@Nullable Bug bug) {
        if (bug != null && bug.getState() != null) {
            HashMap hashMap;
            Map<String, String> map = bug.getUserConsentResponses();
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            if (map != null) {
                hashMap2.putAll(map);
                bug.setUserConsentResponses(null);
            }
            bug.getState().setUserAttributes(UserAttributeCacheManager.getSDKUserAttributesAndAppendToIt(hashMap2));
            return;
        }
    }

    private void compressTheAttachedImages(Context context) {
        Bug bug = ((LiveBugManager)((Object)bug)).bug;
        if (bug != null) {
            for (Attachment attachment : bug.getAttachments()) {
                if (attachment.getType() == null || attachment.getLocalPath() == null || !attachment.getType().equals(Attachment.Type.MAIN_SCREENSHOT) && !attachment.getType().equals(Attachment.Type.EXTRA_IMAGE) && !attachment.getType().equals(Attachment.Type.GALLERY_IMAGE)) continue;
                try {
                    BitmapUtils.compressBitmapAndSave((Context)context, (File)new File(attachment.getLocalPath()));
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Failed to compress attachments");
                }
            }
        }
    }

    private void copyAndDeleteOriginalAttachments(Context context) {
        Bug bug = ((LiveBugManager)((Object)bug)).bug;
        if (bug != null) {
            for (Object object : bug.getAttachments()) {
                Object object2;
                Context context2;
                Attachment attachment;
                if (object.getType() == null || object.getLocalPath() == null) continue;
                try {
                    attachment = object;
                    context2 = context;
                    object2 = bug;
                    object = object.getLocalPath();
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Failed to compress attachments");
                    continue;
                }
                attachment.setLocalPath(FileUtils.copyAndDeleteOriginalFile((Context)context2, (String)object, (String)((Bug)object2).getAttachmentsPath()));
            }
        }
    }

    private void addAttachmentFiles(Context context) {
        LinkedHashMap linkedHashMap = InstabugCore.getExtraAttachmentFiles();
        if (linkedHashMap != null) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                if (context == null) continue;
                Map.Entry entry2 = entry;
                Uri uri = (Uri)entry2.getKey();
                Attachment.Type type = Attachment.Type.ATTACHMENT_FILE;
                this.addExternalAttachment(context, uri, (String)entry2.getValue(), type);
            }
        }
    }

    private void addReprostepsAttachments(Context context) {
        Bug bug = this.bug;
        if (ServiceLocator.getConfigurationsProvider().isReproScreenshotsEnabled() && bug != null && bug.getId() != null) {
            VisualUserStepsHelper.getVisualUserStepsFileObservable((Context)context, (String)bug.getId()).subscribe(processedUri -> {
                if (processedUri.getUri() != null) {
                    LiveBugManager liveBugManager = object;
                    Bug bug2 = bug;
                    Context context2 = context;
                    Object object = processedUri.getUri().getPath();
                    object = Uri.parse((String)FileUtils.copyAndDeleteOriginalFile((Context)context2, (String)object, (String)BugUtils.getBugAttachmentFolder(context2, bug.getId())));
                    bug = Attachment.Type.VISUAL_USER_STEPS;
                    boolean bl = processedUri.isUriEncrypted();
                    bug2.addAttachment((Uri)object, (Attachment.Type)bug, bl);
                    liveBugManager.bug = bug2;
                }
            }, throwable -> InstabugSDKLogger.e((String)"IBG-BR", (String)"something went wrong while getting Visual User Steps File Observable", (Throwable)throwable));
        }
    }

    private void runOnSdkDismissedRunnable() {
        BugSettings bugSettings = BugSettings.getInstance();
        if (bugSettings.getOnSdkDismissCallback() != null && LiveBugManager.getInstance().getDismissType() != null && LiveBugManager.getInstance().getBug() != null) {
            bugSettings.getOnSdkDismissCallback().call(ReportingPluginWrapper.getDismissType(LiveBugManager.getInstance().getDismissType()), ReportingPluginWrapper.getReportType(LiveBugManager.getInstance().getBug().getType()));
        }
    }

    public void releaseBug() {
        this.bug = null;
    }

    public void removeBug() {
        if (this.bug != null && this.bug.getAttachments() != null) {
            for (Attachment attachment : this.bug.getAttachments()) {
                if (attachment.getLocalPath() == null) continue;
                DiskUtils.deleteFile((String)attachment.getLocalPath());
            }
        }
        this.releaseBug();
    }

    @Nullable
    public Bug getBug() {
        return this.bug;
    }

    public void setBug(Bug bug) {
        LiveBugManager liveBugManager = this;
        liveBugManager.bug = bug;
        liveBugManager.isInBackground = false;
        liveBugManager.dismissType = OnSdkDismissedCallback$DismissType.CANCEL;
    }

    public void createBug(Context context) {
        if (this.bug == null) {
            Bug bug = new Bug.Factory().create(context);
            bug.setAttachmentsPath(BugUtils.getBugAttachmentFolder(context, bug.getId()));
            this.setBug(bug);
            this.startStateBuilder(context);
        }
    }

    public void addImageAttachment(Context context, Uri uri, Attachment.Type type) {
        this.addExternalAttachment(context, uri, null, type);
    }

    public void addVideoAttachment(Context context, Uri uri, Attachment.Type type) {
        this.addExternalAttachment(context, uri, null, type);
    }

    @WorkerThread
    public void addExternalAttachment(Context context, Uri uri, @Nullable String string2, Attachment.Type type) {
        Bug bug = this.bug;
        if (bug != null && (uri = type == Attachment.Type.GALLERY_VIDEO ? AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)uri, (String)string2, (double)50.0) : AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)uri, (String)string2)) != null) {
            bug.addAttachment(uri, type);
            this.refreshAttachments(context);
        }
    }

    public void addExternalAttachmentWithoutCopying(Context context, File file, Attachment.Type type) {
        if (this.getBug() == null) {
            return;
        }
        this.getBug().addAttachment(Uri.fromFile((File)file), type);
        this.refreshAttachments(context);
    }

    public void refreshAttachments(Context context) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent("refresh.attachments"));
    }

    @Nullable
    public OnSdkDismissedCallback$DismissType getDismissType() {
        return this.dismissType;
    }

    public void setDismissType(OnSdkDismissedCallback$DismissType onSdkDismissedCallback$DismissType) {
        this.dismissType = onSdkDismissedCallback$DismissType;
    }

    public boolean isInBackground() {
        return this.isInBackground;
    }

    public void setIsInBackground(boolean bl) {
        this.isInBackground = bl;
    }

    public void commit() {
        if (Instabug.getApplicationContext() != null) {
            if (ServiceLocator.getConfigurationsProvider().isBugReportingUsageExceeded()) {
                this.removeBug();
            } else {
                this.commit(Instabug.getApplicationContext());
            }
        }
    }

    public void commit(final Context context) {
        ActionsOrchestrator.obtainOrchestrator((Executor)PoolProvider.getBugsExecutor()).addWorkerThreadAction(new Action(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block14: {
                    block11: {
                        JSONException jSONException2;
                        block13: {
                            Bug bug;
                            block10: {
                                bug = LiveBugManager.this.bug;
                                if (bug == null) break block14;
                                SettingsManager settingsManager = SettingsManager.getInstance();
                                if (settingsManager.getOnReportCreatedListener() != null) {
                                    Report report;
                                    SettingsManager settingsManager2 = settingsManager;
                                    settingsManager = report;
                                    report = new Report();
                                    try {
                                        settingsManager2.getOnReportCreatedListener().onReportCreated((Report)settingsManager);
                                    }
                                    catch (Exception exception) {
                                        InstabugSDKLogger.e((String)"IBG-BR", (String)"Exception occurred in report Submit Handler ", (Throwable)exception);
                                    }
                                    if (LiveBugManager.getInstance().getBug() != null) {
                                        ReportHelper.update((State)LiveBugManager.getInstance().getBug().getState(), (Report)settingsManager);
                                    }
                                }
                                1 v2 = this;
                                1 v3 = this;
                                v3.LiveBugManager.this.addAttachmentFiles(context);
                                v3.LiveBugManager.this.copyAndDeleteOriginalAttachments(context);
                                v3.LiveBugManager.this.compressTheAttachedImages(context);
                                v3.LiveBugManager.this.addReprostepsAttachments(context);
                                AttachmentsUtility.encryptAttachments(bug.getAttachments());
                                v2.LiveBugManager.this.updateBugState();
                                v2.LiveBugManager.this.setDismissType(OnSdkDismissedCallback$DismissType.SUBMIT);
                                ServiceLocator.getConsentsActionHandler().handle(bug);
                                v2.LiveBugManager.this.handleDroppingLogsForFrustratingExperienceBugs(bug);
                                settingsManager = bug.getState();
                                if (settingsManager != null) {
                                    LiveBugManager.this.prepareState(context, (State)settingsManager);
                                    break block10;
                                }
                                bug.setState(State.getState((Context)context));
                            }
                            try {
                                1 v4 = this;
                                v4.LiveBugManager.this.saveBugToDB(bug);
                                v4.LiveBugManager.this.sendBug();
                                break block11;
                            }
                            catch (IOException iOException) {
                            }
                            catch (JSONException jSONException2) {
                                break block13;
                            }
                            InstabugSDKLogger.e((String)"IBG-BR", (String)"IOException while committing bug", (Throwable)iOException);
                            ReportUploadingStateEventBus.INSTANCE.postError(iOException);
                            break block11;
                        }
                        InstabugSDKLogger.e((String)"IBG-BR", (String)"Error while committing bug: ", (Throwable)jSONException2);
                        ReportUploadingStateEventBus.INSTANCE.postError(jSONException2);
                    }
                    AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                        @Override
                        public void run() {
                            1 v0 = this;
                            v0.LiveBugManager.this.runOnSdkDismissedRunnable();
                            v0.LiveBugManager.this.releaseBug();
                            v0.LiveBugManager.this.triggerSync();
                        }
                    });
                }
            }
        }).orchestrate();
    }

    @VisibleForTesting
    void postFrustratingExperienceReportSaved(Bug bug) {
        if (bug.getFrustratingExperienceInternalId() != 0L && bug.getFrustratingExperienceExternalId() == null) {
            FrustratingExperienceEventBus.INSTANCE.post((Object)new FrustratingExperienceEvent.BugReportSaved(bug.getFrustratingExperienceInternalId()));
        }
    }

    public void updateBugState() {
        if (this.bug != null && this.bug.getState() != null) {
            Context context = Instabug.getApplicationContext();
            if (context != null && !MemoryUtils.isLowMemory((Context)context) && InstabugCore.getFeatureState((String)"USER_EVENTS") == Feature.State.ENABLED) {
                try {
                    this.bug.getState().setUserEvents(UserEvent.toJson((List)InstabugUserEventLogger.getInstance().getUserEvents()).toString());
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Got error while parsing user events logs", (Throwable)jSONException);
                }
            }
            if ((this.bug == null ? null : this.bug.getState()) != null) {
                if (SettingsManager.getInstance().getOnReportCreatedListener() == null) {
                    LiveBugManager liveBugManager = this;
                    liveBugManager.bug.getState().setTags(InstabugCore.getTagsAsString());
                    liveBugManager.bug.getState().updateConsoleLog();
                    context = Feature.State.ENABLED;
                    if (InstabugCore.getFeatureState((String)"USER_DATA") == context) {
                        this.bug.getState().setUserData(InstabugCore.getUserData());
                    }
                    if (InstabugCore.getFeatureState((String)"INSTABUG_LOGS") == context) {
                        this.bug.getState().setInstabugLog(InstabugLog.getLogs());
                    }
                }
                LiveBugManager liveBugManager = this;
                liveBugManager.setUserAttributes(liveBugManager.bug);
                if (ServiceLocator.getConfigurationsProvider().isReproStepsEnabled()) {
                    this.bug.getState().updateVisualUserSteps();
                }
                LiveBugManager liveBugManager2 = this;
                liveBugManager2.bug.getState().setScreenShotAnalytics(((JSONObject)CoreServiceLocator.getScreenShotAnalyticsMapper().map((Object)ServiceLocator.getBugsProductAnalyticsCollector().getAnalytics())).toString());
                liveBugManager2.bug.getState().setCurrentView(InstabugCore.getCurrentView());
            }
        }
    }

    public void onSdkDismissedForAttachment() {
        LiveBugManager liveBugManager = this;
        liveBugManager.setIsInBackground(true);
        liveBugManager.setDismissType(OnSdkDismissedCallback$DismissType.ADD_ATTACHMENT);
        liveBugManager.runOnSdkDismissedRunnable();
    }

    public void sendBug() {
        if (Instabug.getApplicationContext() != null) {
            NormalBugsUploaderJob.getInstance().start();
            ProactiveReportsBugsUploaderJob.getInstance().start();
        }
    }

    public void setRecordingDuration(int n) {
        this.recordingDuration = n;
    }

    public int getAndResetRecordingDuration() {
        this.recordingDuration = -1;
        return this.recordingDuration;
    }

    @VisibleForTesting
    void handleDroppingLogsForFrustratingExperienceBugs(Bug bug) {
        if (Objects.equals(bug.getType(), "Frustrating experience") && ServiceLocator.getProactiveReportingConfigProvider().getShouldDropLogs()) {
            InstabugSDKLogger.w((String)"IBG-BR", (String)"Logs will be dropped from frustrating experience report.");
            State state = bug.getState();
            if (state != null) {
                State state2 = state;
                StateKtxKt.dropLogs((State)state2);
                state2.setVisualUserSteps(null);
                state2.setSessionProfilerTimeline(null);
            }
            state = null;
            for (Attachment attachment : bug.getAttachments()) {
                if (attachment == null || attachment.getType() == null || !attachment.getType().equals(Attachment.Type.VISUAL_USER_STEPS)) continue;
                DeleteBugsUtilKt.deleteAttachment(attachment, bug.getId());
                state = attachment;
            }
            Bug bug2 = bug;
            bug2.getAttachments().remove(state);
            this.addManuallyAddedConsoleLogsToBug(bug2);
            this.addManuallyAddedInstabugLogsToBug(bug);
        }
    }

    void addManuallyAddedConsoleLogsToBug(Bug bug) {
        LiveBugManager liveBugManager = SettingsManager.getInstance();
        if (liveBugManager.getOnReportCreatedListener() != null) {
            Report report;
            LiveBugManager liveBugManager2 = liveBugManager;
            liveBugManager = report;
            report = new Report();
            try {
                liveBugManager2.getOnReportCreatedListener().onReportCreated((Report)liveBugManager);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Exception occurred in report Submit Handler ", (Throwable)exception);
            }
            bug = bug.getState();
            if (bug != null) {
                bug.addConsoleLogs(liveBugManager.getConsoleLog());
            }
        }
    }

    void addManuallyAddedInstabugLogsToBug(Bug bug) {
        LiveBugManager liveBugManager = SettingsManager.getInstance();
        if (liveBugManager.getOnReportCreatedListener() != null) {
            Report report;
            LiveBugManager liveBugManager2 = liveBugManager;
            liveBugManager = report;
            report = new Report();
            try {
                liveBugManager2.getOnReportCreatedListener().onReportCreated((Report)liveBugManager);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Exception occurred in report Submit Handler ", (Throwable)exception);
            }
            bug = bug.getState();
            if (bug != null) {
                JSONArray jSONArray;
                LiveBugManager liveBugManager3 = liveBugManager;
                liveBugManager = jSONArray;
                jSONArray = new JSONArray();
                Iterator iterator = liveBugManager3.getInstabugLogs().iterator();
                while (iterator.hasNext()) {
                    liveBugManager.put(((InstabugLog.LogMessage)iterator.next()).toJson());
                }
                bug.setInstabugLog(liveBugManager.toString());
            }
        }
    }
}

