/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.ReportingPluginWrapper;
import com.instabug.bug.configurations.BugReportingConfigurationsProvider;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.network.NormalBugsUploaderJob;
import com.instabug.bug.network.ProactiveReportsBugsUploaderJob;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.view.actionList.service.FetchReportCategoriesJob;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.eventbus.eventpublisher.Subscriber;
import com.instabug.library.screenshot.analytics.AnalyticsEvent;
import com.instabug.library.screenshot.analytics.ProductAnalyticsCollector;
import com.instabug.library.screenshot.subscribers.ScreenshotsAnalyticsEventBus;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.ReproCapturingProxy;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0017\u001a\u00020\b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u000f\u0010\u001a\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u000f\u0010\u001b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0003J\u000f\u0010\u001c\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u000f\u0010\u001d\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0003R*\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u001f\u0010 \u0012\u0004\b%\u0010\u0003\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lcom/instabug/bug/BugsCoreEventsHandler;", "", "<init>", "()V", "Landroid/content/Context;", "context", "Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;", "coreEvent", "", "handleCoreEvents", "(Landroid/content/Context;Lcom/instabug/library/core/eventbus/coreeventbus/IBGSdkCoreEvent;)V", "handleSessionStarted", "handleNetworkActivated", "clearUserActivities", "migrateBugsToEncryptedTable", "(Landroid/content/Context;)V", "", "configurations", "handleConfigurations", "(Ljava/lang/String;)V", "", "", "modesMap", "handleReproState", "(Ljava/util/Map;)V", "handleSDKDismissing", "removeBug", "runOnSdkDismissedRunnable", "subscribeToProductAnalyticsCollector", "unsubscribeFromProductAnalyticsCollector", "Lcom/instabug/library/core/eventbus/eventpublisher/IBGDisposable;", "screenshotsAnalyticsDisposables", "Lcom/instabug/library/core/eventbus/eventpublisher/IBGDisposable;", "getScreenshotsAnalyticsDisposables", "()Lcom/instabug/library/core/eventbus/eventpublisher/IBGDisposable;", "setScreenshotsAnalyticsDisposables", "(Lcom/instabug/library/core/eventbus/eventpublisher/IBGDisposable;)V", "getScreenshotsAnalyticsDisposables$annotations", "instabug-bug_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nBugsCoreEventsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BugsCoreEventsHandler.kt\ncom/instabug/bug/BugsCoreEventsHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class BugsCoreEventsHandler {
    @NotNull
    public static final BugsCoreEventsHandler INSTANCE = new BugsCoreEventsHandler();
    @Nullable
    private static IBGDisposable screenshotsAnalyticsDisposables;

    private BugsCoreEventsHandler() {
    }

    @JvmStatic
    public static final void handleCoreEvents(@Nullable Context context, @NotNull IBGSdkCoreEvent iBGSdkCoreEvent) {
        IBGSdkCoreEvent iBGSdkCoreEvent2 = iBGSdkCoreEvent;
        Intrinsics.checkNotNullParameter((Object)iBGSdkCoreEvent2, (String)"coreEvent");
        InstabugSDKLogger.v((String)"IBG-BR", (String)("receive new IBG core event: " + iBGSdkCoreEvent));
        if (Intrinsics.areEqual((Object)iBGSdkCoreEvent2, (Object)IBGSdkCoreEvent.NetworkActivated.INSTANCE)) {
            INSTANCE.handleNetworkActivated();
        } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.Session.SessionStarted.INSTANCE)) {
            INSTANCE.handleSessionStarted();
        } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.User.LoggedOut.INSTANCE)) {
            INSTANCE.clearUserActivities();
        } else if (Intrinsics.areEqual((Object)iBGSdkCoreEvent, (Object)IBGSdkCoreEvent.SdkVersionChanged.INSTANCE)) {
            if (context != null) {
                INSTANCE.migrateBugsToEncryptedTable(context);
            }
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.FeaturesFetched) {
            INSTANCE.handleConfigurations(((IBGSdkCoreEvent.FeaturesFetched)iBGSdkCoreEvent).getResponse());
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.ReproState) {
            INSTANCE.handleReproState(((IBGSdkCoreEvent.ReproState)iBGSdkCoreEvent).getModesMap());
        }
    }

    private final void handleSessionStarted() {
        FetchReportCategoriesJob.getInstance().start();
    }

    private final void handleNetworkActivated() {
        NormalBugsUploaderJob.Companion.getInstance().start();
        ProactiveReportsBugsUploaderJob.Companion.getInstance().start();
    }

    private final void clearUserActivities() {
        BugSettings.getInstance().setLastBugTime(0L);
    }

    private final void migrateBugsToEncryptedTable(Context context) {
        ServiceLocator.getBugReportsDbMigrationHelper().migrateToEncrypted(context);
    }

    private final void handleConfigurations(String string2) {
        ServiceLocator.getConfigurationsHandler().handleConfigurations(string2);
        ReproCapturingProxy reproCapturingProxy = ServiceLocator.getReproProxy();
        BugReportingConfigurationsProvider bugReportingConfigurationsProvider = ServiceLocator.getConfigurationsProvider();
        Intrinsics.checkNotNullExpressionValue((Object)bugReportingConfigurationsProvider, (String)"getConfigurationsProvider()");
        reproCapturingProxy.evaluate((ReproConfigurationsProvider)bugReportingConfigurationsProvider);
        ScreenshotsAnalyticsEventBus.INSTANCE.post((Object)AnalyticsEvent.ScreenshotEvent.OnConfigurationChanged.INSTANCE);
    }

    private final void handleReproState(Map<Integer, Integer> map) {
        ServiceLocator.getConfigurationsHandler().handle(map);
        ReproCapturingProxy reproCapturingProxy = ServiceLocator.getReproProxy();
        BugReportingConfigurationsProvider bugReportingConfigurationsProvider = ServiceLocator.getConfigurationsProvider();
        Intrinsics.checkNotNullExpressionValue((Object)bugReportingConfigurationsProvider, (String)"getConfigurationsProvider()");
        reproCapturingProxy.evaluate((ReproConfigurationsProvider)bugReportingConfigurationsProvider);
        ScreenshotsAnalyticsEventBus.INSTANCE.post((Object)AnalyticsEvent.ScreenshotEvent.OnConfigurationChanged.INSTANCE);
    }

    @JvmStatic
    public static final void handleSDKDismissing() {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"SDK dismissed Handle sdk dismissing");
        BugsCoreEventsHandler bugsCoreEventsHandler = INSTANCE;
        bugsCoreEventsHandler.runOnSdkDismissedRunnable();
        bugsCoreEventsHandler.removeBug();
    }

    private final void removeBug() {
        LiveBugManager.getInstance().removeBug();
    }

    private final void runOnSdkDismissedRunnable() {
        if (BugSettings.getInstance().getOnSdkDismissCallback() != null && LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getDismissType() != null) {
            OnSdkDismissCallback onSdkDismissCallback = BugSettings.getInstance().getOnSdkDismissCallback();
            Intrinsics.checkNotNull((Object)onSdkDismissCallback);
            OnSdkDismissCallback.DismissType dismissType = ReportingPluginWrapper.getDismissType(LiveBugManager.getInstance().getDismissType());
            Bug bug = LiveBugManager.getInstance().getBug();
            Intrinsics.checkNotNull((Object)bug);
            onSdkDismissCallback.call(dismissType, ReportingPluginWrapper.getReportType(bug.getType()));
        }
    }

    @JvmStatic
    public static final void subscribeToProductAnalyticsCollector() {
        if (screenshotsAnalyticsDisposables == null) {
            ProductAnalyticsCollector productAnalyticsCollector = ServiceLocator.getBugsProductAnalyticsCollector();
            Intrinsics.checkNotNullExpressionValue((Object)productAnalyticsCollector, (String)"getBugsProductAnalyticsCollector()");
            screenshotsAnalyticsDisposables = ScreenshotsAnalyticsEventBus.INSTANCE.subscribe((Subscriber)productAnalyticsCollector);
        }
    }

    @JvmStatic
    public static final void unsubscribeFromProductAnalyticsCollector() {
        IBGDisposable iBGDisposable = screenshotsAnalyticsDisposables;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
        }
        screenshotsAnalyticsDisposables = null;
    }
}

