/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class a {
    private static a c;
    @VisibleForTesting
    Request a;
    private final NetworkManager b;

    private a() {
        NetworkManager networkManager;
        a a2 = networkManager;
        networkManager = new NetworkManager();
        v1.b = a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static a a() {
        String string2 = a.class.getName();
        synchronized (string2) {
            if (c == null) {
                c = new a();
            }
            return c;
        }
    }

    public void a(final Context context, com.instabug.bug.model.a a2, final Request.Callbacks<String, Throwable> callbacks) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        a a3 = this;
        InstabugSDKLogger.d((Object)"BugsService", (String)"Reporting a bug...");
        a2 = a3.b(a2);
        a3.a = a2;
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(this){

            public void a(RequestResponse requestResponse) {
                block5: {
                    InstabugSDKLogger.d((Object)"BugsService", (String)("reportingBugRequest succeeded, Response code: " + requestResponse.getResponseCode()));
                    if (SettingsManager.shouldLogExtraRequestData()) {
                        InstabugSDKLogger.d((Object)"BugsService", (String)("Response body: " + requestResponse.getResponseBody()));
                    }
                    if (requestResponse.getResponseBody() == null) break block5;
                    try {
                        calendar.callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                    }
                    catch (JSONException jSONException) {
                        InstabugCore.reportError((Throwable)jSONException, (String)("Reporting bug got an error: " + jSONException.getMessage()));
                        InstabugSDKLogger.e((Object)"BugsService", (String)("reportingBugRequest onNext got error: " + jSONException.getMessage()), (Throwable)jSONException);
                        calendar.callbacks.onFailed((Object)jSONException);
                    }
                }
                if (requestResponse.getResponseCode() == 200) {
                    Intent intent;
                    a a2 = calendar;
                    Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                    InstabugSDKLogger.d((Object)"BugsService", (String)("Updating last_contacted_at to " + calendar.getTime()));
                    com.instabug.bug.settings.b.f().a(calendar.getTime().getTime());
                    InstabugCore.setLastContactedAt((long)calendar.getTime().getTime());
                    RequestResponse requestResponse2 = requestResponse = intent;
                    requestResponse2();
                    requestResponse2.setAction("User last contact at changed");
                    long l2 = calendar.getTime().getTime();
                    intent.putExtra("last_contacted_at", l2);
                    LocalBroadcastManager.getInstance((Context)a2.context).sendBroadcast((Intent)requestResponse);
                }
            }

            public void a(Throwable throwable) {
                InstabugCore.reportError((Throwable)throwable, (String)("Reporting bug got an error: " + throwable.getMessage()));
                InstabugSDKLogger.e((Object)"BugsService", (String)("reportingBugRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }
        };
        a3.b.doRequestOnSameThread(1, (Request)a2, (Request.Callbacks)callbacks3);
    }

    @VisibleForTesting
    Request b(com.instabug.bug.model.a a2) {
        Request.Builder builder = new Request.Builder().endpoint("/bugs").method("POST");
        builder.addParameter(new RequestParameter("title", (Object)a2.g()));
        builder.addParameter(new RequestParameter("attachments_count", (Object)a2.a().size()));
        builder.addParameter(new RequestParameter("categories", (Object)a2.d()));
        this.a = this.a(builder, a2);
        return this.a;
    }

    @VisibleForTesting
    Request a(Request.Builder builder, com.instabug.bug.model.a object) {
        if (object.getState() != null) {
            ArrayList arrayList = object.getState().getStateItems();
            object = Arrays.asList(State.getUserDataKeys());
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                RequestParameter requestParameter;
                String string2 = ((State.StateItem)arrayList.get(i2)).getKey();
                Object object2 = ((State.StateItem)arrayList.get(i2)).getValue();
                if (string2 == null || object2 == null) continue;
                if (!object.contains(string2)) {
                    InstabugSDKLogger.d((Object)"BugsService", (String)("Bug State Key: " + string2 + ", Bug State value: " + object2));
                }
                RequestParameter requestParameter2 = requestParameter;
                requestParameter = new RequestParameter(string2, object2);
                builder.addParameter(requestParameter2);
            }
        }
        return builder.build();
    }

    public void a(final com.instabug.bug.model.a a2, final Request.Callbacks<Boolean, com.instabug.bug.model.a> callbacks) {
        ArrayList arrayList;
        InstabugSDKLogger.d((Object)"BugsService", (String)"Uploading Bug attachments");
        if (a2.a().isEmpty()) {
            callbacks.onSucceeded((Object)Boolean.TRUE);
            return;
        }
        final ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (int i2 = 0; i2 < a2.a().size(); ++i2) {
            File file;
            final Attachment attachment = a2.a().get(i2);
            boolean bl = AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment);
            if (attachment.getLocalPath() == null || attachment.getName() == null) continue;
            Object object = file;
            file = new File(attachment.getLocalPath());
            if (bl && ((File)object).exists() && ((File)object).length() > 0L) {
                Request.Callbacks<RequestResponse, Throwable> callbacks2;
                Object object2 = new Request.Builder().endpoint("/bugs/:bug_token/attachments").method("POST").type(2);
                if (a2.h() != null) {
                    object = a2.h();
                    object2.endpoint("/bugs/:bug_token/attachments".replaceAll(":bug_token", (String)object));
                }
                if (attachment.getType() != null) {
                    object2.addParameter(new RequestParameter("metadata[file_type]", (Object)attachment.getType()));
                    if (attachment.getType() == Attachment.Type.AUDIO && attachment.getDuration() != null) {
                        RequestParameter requestParameter;
                        object = requestParameter;
                        requestParameter = new RequestParameter("metadata[duration]", (Object)attachment.getDuration());
                        object2.addParameter((RequestParameter)object);
                    }
                }
                attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
                Attachment attachment2 = attachment;
                object = attachment2.getName();
                String string2 = attachment2.getLocalPath();
                String string3 = attachment2.getFileType();
                object2.fileToUpload(new FileToUpload("file", (String)object, string2, string3));
                Request request = object2.build();
                object2 = callbacks2;
                callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(this){

                    public void a(RequestResponse requestResponse) {
                        InstabugSDKLogger.d((Object)"BugsService", (String)("uploadingBugAttachmentRequest succeeded, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody()));
                        if (attachment.getLocalPath() != null) {
                            if (new File(attachment.getLocalPath()).delete()) {
                                InstabugSDKLogger.d((Object)"BugsService", (String)"uploadingBugAttachmentRequest succeeded, attachment file deleted successfully");
                            }
                            b b2 = this;
                            b2.arrayList2.add(attachment);
                            if (b2.attachment.getId() != -1L) {
                                AttachmentsDbHelper.delete((long)attachment.getId());
                            } else if (attachment.getName() != null && a2.getId() != null) {
                                AttachmentsDbHelper.delete((String)attachment.getName(), (String)a2.getId());
                            }
                        }
                        if (arrayList2.size() == a2.a().size()) {
                            callbacks.onSucceeded((Object)Boolean.TRUE);
                        }
                    }

                    public void a(Throwable throwable) {
                        b b2 = this;
                        InstabugSDKLogger.e((Object)"BugsService", (String)("uploadingBugAttachmentRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                        AttachmentsUtility.encryptAttachmentsAndUpdateDb(b2.a2.a());
                        b2.callbacks.onFailed((Object)a2);
                    }
                };
                this.b.doRequestOnSameThread(2, request, (Request.Callbacks)object2);
                continue;
            }
            if (!bl) {
                InstabugSDKLogger.e((Object)"BugsService", (String)("Skipping attachment file of type " + attachment.getType() + " because it was not decrypted successfully"));
                continue;
            }
            if (((File)object).exists() && ((File)object).length() > 0L) continue;
            InstabugSDKLogger.e((Object)"BugsService", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
        }
    }

    public void b(final com.instabug.bug.model.a a2, final Request.Callbacks<Boolean, com.instabug.bug.model.a> callbacks) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        a a3 = this;
        a a4 = a3;
        Object object = a3.a(a2);
        NetworkManager networkManager = a4.b;
        Request request = object;
        object = callbacks2;
        try {
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(this){

                public void a(RequestResponse requestResponse) {
                    InstabugSDKLogger.addVerboseLog((Object)"BugsService", (String)("uploading bug logs onNext, Response code: " + requestResponse.getResponseCode()));
                    if (SettingsManager.shouldLogExtraRequestData()) {
                        InstabugSDKLogger.addVerboseLog((Object)"BugsService", (String)("uploading bug logs onNext, Response body: " + requestResponse.getResponseBody()));
                    }
                    callbacks.onSucceeded((Object)Boolean.TRUE);
                }

                public void a(Throwable throwable) {
                    InstabugCore.reportError((Throwable)throwable, (String)("uploading bug logs got error: " + throwable.getMessage()));
                    InstabugSDKLogger.e((Object)"BugsService", (String)"uploading bug logs got error", (Throwable)throwable);
                    callbacks.onFailed((Object)a2);
                }
            };
            networkManager.doRequestOnSameThread(1, request, (Request.Callbacks)object);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((Object)"BugsService", (String)"uploading bug logs got Json error ", (Throwable)exception);
            callbacks.onFailed((Object)a2);
        }
    }

    @VisibleForTesting
    Request a(com.instabug.bug.model.a a2) {
        Object object;
        a a3 = new Request.Builder().endpoint("/bugs/:bug_token/state_logs").method("POST");
        if (a2.h() != null) {
            object = a2.h();
            a3.endpoint("/bugs/:bug_token/state_logs".replaceAll(":bug_token", (String)object));
        }
        if ((object = a2.getState() != null ? a2.getState().getLogsItems() : null) != null) {
            for (Object object2 : object) {
                RequestParameter requestParameter;
                if (object2.getKey() == null || object2.getValue() == null) continue;
                RequestParameter requestParameter2 = requestParameter;
                State.StateItem stateItem = object2;
                object2 = stateItem.getKey();
                requestParameter = new RequestParameter((String)object2, stateItem.getValue());
                a3.addParameter(requestParameter2);
            }
        }
        if (a2.j() != null) {
            RequestParameter requestParameter;
            object = requestParameter;
            requestParameter = new RequestParameter("view_hierarchy", (Object)a2.j());
            a3.addParameter((RequestParameter)object);
        }
        return a3.build();
    }
}

