/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.SessionHolder;
import com.ing.data.cassandra.jdbc.utils.DriverUtil;
import com.ing.data.cassandra.jdbc.utils.JdbcUrlUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDriver
implements Driver {
    private static final Logger LOG;
    private final LoadingCache<Map<String, String>, SessionHolder> sessionsCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<Map<String, String>, SessionHolder>(){

        public SessionHolder load(@Nonnull Map<String, String> params) throws Exception {
            return new SessionHolder(params, (LoadingCache<Map<String, String>, SessionHolder>)CassandraDriver.this.sessionsCache);
        }
    });

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:cassandra:");
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        if (this.acceptsURL(url)) {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("contactPoints".equals(key)) continue;
                params.put(key, properties.getProperty(key));
            }
            params.put("jdbcUrl", url);
            Map cacheKey = Collections.unmodifiableMap(params);
            try {
                SessionHolder sessionHolder;
                while ((sessionHolder = (SessionHolder)this.sessionsCache.get(cacheKey)) == null || !sessionHolder.acquire()) {
                }
                return new CassandraConnection(sessionHolder);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLNonTransientConnectionException("Unexpected error while creating connection.", e);
            }
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return DriverUtil.safeParseVersion(DriverUtil.getDriverProperty("driver.version")).getMajor();
    }

    @Override
    public int getMinorVersion() {
        return DriverUtil.safeParseVersion(DriverUtil.getDriverProperty("driver.version")).getMinor();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) {
        Properties properties;
        try {
            properties = JdbcUrlUtil.parseURL(url);
            for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
                properties.putIfAbsent(propEntry.getKey(), propEntry.getValue());
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to extract properties from the given URL.", (Throwable)e);
            properties = new Properties(props);
        }
        List<String> availableProperties = Arrays.asList("user", "password", "localDatacenter", "debug", "consistencyLevel", "activeProfile", "fetchSize", "loadBalancing", "retry", "reconnection", "enableSsl", "sslEngineFactory", "hostnameVerification", "secureConnectBundle", "useKerberos", "requestTimeout", "connectTimeout", "tcpNoDelay", "keepAlive", "configFile", "complianceMode");
        ArrayList<DriverPropertyInfo> info = new ArrayList<DriverPropertyInfo>();
        for (String propertyName : availableProperties) {
            info.add(DriverUtil.buildPropertyInfo(propertyName, properties.get(propertyName)));
        }
        return info.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    static {
        try {
            CassandraDriver driverInstance = new CassandraDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        LOG = LoggerFactory.getLogger(CassandraDriver.class);
    }
}

