/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Words;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import com.infoedge.jrandomizer.providers.WordsProvider;

public class WordsGenerator
extends GenerationRule<Words, String> {
    private WordsProvider mProvider = this.providerFactory().provider(WordsProvider.class, String[].class);
    private int atleast;
    private int noMoreThan;

    public WordsGenerator(Words annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.atleast = annotation.atleast();
        this.noMoreThan = annotation.noMoreThan();
        if (this.noMoreThan < this.atleast) {
            this.noMoreThan = this.atleast;
        }
    }

    @Override
    public String generate() {
        int random = (int)((double)this.atleast + Math.random() * (double)(this.noMoreThan - this.atleast + 1));
        return this.chooseWords(random);
    }

    private String chooseWords(int length) {
        String[] wordsData = this.mProvider.provide();
        int random = 0;
        int wordsRemaining = length;
        StringBuilder words = new StringBuilder();
        while (wordsRemaining > 0) {
            random = this.getRandom().nextInt(wordsData.length);
            String line = wordsData[random];
            String[] lineWords = line.split(" ");
            if (wordsRemaining < lineWords.length) {
                for (int i = 0; i < wordsRemaining; ++i) {
                    words.append(lineWords[i] + " ");
                }
                wordsRemaining = 0;
                continue;
            }
            words.append(line + " ");
            wordsRemaining -= lineWords.length;
        }
        return words.toString().trim();
    }
}

