/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.Utils;
import com.infoedge.jrandomizer.annotations.URL;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import com.infoedge.jrandomizer.providers.URLProvider;

public class URLGenerator
extends GenerationRule<URL, String> {
    private URLProvider mProvider = this.providerFactory().provider(URLProvider.class, URLProvider.URLData.class);

    public URLGenerator(URL annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
    }

    @Override
    public String generate() {
        URLProvider.URLData urlData = (URLProvider.URLData)this.mProvider.provide();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(((URL)this.getAnnotation()).protocol() ? urlData.protocols[this.getRandom().nextInt(urlData.protocols.length)] + "://" : "");
        urlBuilder.append(((URL)this.getAnnotation()).host() ? urlData.hosts[this.getRandom().nextInt(urlData.hosts.length)] : "");
        urlBuilder.append(((URL)this.getAnnotation()).host() && ((URL)this.getAnnotation()).port() ? ":" + Utils.randomIntWithMinMax(8000, 9000) : "");
        urlBuilder.append(((URL)this.getAnnotation()).path() ? urlData.paths[this.getRandom().nextInt(urlData.paths.length)] : "");
        urlBuilder.append(((URL)this.getAnnotation()).queryParams() && ((URL)this.getAnnotation()).maxQueryParams() > 0 ? this.randomQueryParams(urlData) : "");
        return urlBuilder.toString();
    }

    private String randomQueryParams(URLProvider.URLData urlData) {
        int count = Utils.randomIntWithMinMax(0, ((URL)this.getAnnotation()).maxQueryParams());
        if (count == 0) {
            return "";
        }
        StringBuilder queryParamsBuilder = new StringBuilder(((URL)this.getAnnotation()).maxQueryParams() > 0 ? "?" : "");
        for (int i = 0; i < count; ++i) {
            int randomIndex = this.getRandom().nextInt(urlData.queryParams.length);
            queryParamsBuilder.append(urlData.queryParams[randomIndex]);
            if (i >= count - 1) continue;
            queryParamsBuilder.append("&");
        }
        return queryParamsBuilder.toString();
    }
}

