/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Sequence;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class SequenceGenerator
extends GenerationRule<Sequence, Integer> {
    int startAt;
    int step;
    int repeat;
    int restartAt;
    int repeatCounter;
    int nextSequence;

    public SequenceGenerator(Sequence annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.startAt = annotation.startAt();
        this.step = annotation.step();
        this.repeat = annotation.repeat();
        this.restartAt = annotation.restartAt();
        if (this.repeat < 1) {
            this.repeat = 1;
        }
        if (this.step < 1) {
            this.step = 1;
        }
        this.repeatCounter = this.repeat;
        this.nextSequence = this.startAt;
    }

    @Override
    public Integer generate() {
        if (this.nextSequence > this.restartAt) {
            this.nextSequence = this.startAt;
        }
        if (this.repeatCounter > 1) {
            --this.repeatCounter;
            return this.nextSequence;
        }
        this.repeatCounter = this.repeat;
        int lastSequence = this.nextSequence;
        this.nextSequence += this.step;
        return lastSequence;
    }
}

