/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Sentences;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;
import com.infoedge.jrandomizer.providers.SentencesProvider;

public class SentencesGenerator
extends GenerationRule<Sentences, String> {
    private SentencesProvider mProvider = this.providerFactory().provider(SentencesProvider.class, String[].class);
    private int atleast;
    private int noMoreThan;

    public SentencesGenerator(Sentences annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.atleast = annotation.atleast();
        this.noMoreThan = annotation.noMoreThan();
        if (this.noMoreThan < this.atleast) {
            this.noMoreThan = this.atleast;
        }
    }

    @Override
    public String generate() {
        String[] sentencesData = this.mProvider.provide();
        int diff = this.noMoreThan - this.atleast + 1;
        int random = this.getRandom().nextInt(diff) + this.atleast;
        StringBuilder sentences = new StringBuilder();
        for (int i = 0; i < random; ++i) {
            int randomIndex = this.getRandom().nextInt(sentencesData.length);
            sentences.append(sentencesData[randomIndex]);
            if (i >= random - 1) continue;
            sentences.append(" ");
        }
        return sentences.toString();
    }
}

