/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Paragraphs;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ParagraphsProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class ParagraphsGenerator
extends GenerationRule<Paragraphs, String> {
    private ParagraphsProvider mProvider = this.providerFactory().provider(ParagraphsProvider.class, String[].class);
    private int atleast;
    private int noMoreThan;

    public ParagraphsGenerator(Paragraphs annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.atleast = annotation.atleast();
        this.noMoreThan = annotation.noMoreThan();
        if (this.noMoreThan < this.atleast) {
            this.noMoreThan = this.atleast;
        }
    }

    @Override
    public String generate() {
        String[] paragraphsData = this.mProvider.provide();
        int diff = this.noMoreThan - this.atleast + 1;
        int random = this.getRandom().nextInt(diff) + this.atleast;
        StringBuilder paragraphs = new StringBuilder();
        for (int i = 0; i < random; ++i) {
            int randomIndex = this.getRandom().nextInt(paragraphsData.length);
            paragraphs.append(paragraphsData[randomIndex]);
            if (i >= random - 1) continue;
            paragraphs.append("\n");
        }
        return paragraphs.toString();
    }
}

