/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.MimeType;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.MimeTypeProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class MimeTypeGenerator
extends GenerationRule<MimeType, String> {
    private MimeTypeProvider mProvider;
    private MimeType.Type mimeType;

    public MimeTypeGenerator(MimeType annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.mimeType = annotation.type();
        this.mProvider = this.providerFactory().provider(MimeTypeProvider.class, MimeTypeProvider.MimeTypeData.class);
    }

    @Override
    public String generate() {
        MimeTypeProvider.MimeTypeData mimeTypeData = (MimeTypeProvider.MimeTypeData)this.mProvider.provide();
        return this.getRandomMimeType(mimeTypeData, this.mimeType);
    }

    private String getRandomMimeType(MimeTypeProvider.MimeTypeData mimeTypeData, MimeType.Type type) {
        String[] data = mimeTypeData.all;
        switch (type) {
            case ALL: {
                data = mimeTypeData.all;
                break;
            }
            case COMMON: {
                data = mimeTypeData.common;
                break;
            }
            case CODE: {
                data = mimeTypeData.code;
                break;
            }
            case DOCUMENT: {
                data = mimeTypeData.document;
                break;
            }
            case IMAGE: {
                data = mimeTypeData.image;
                break;
            }
            case MEDIA: {
                data = mimeTypeData.media;
                break;
            }
            case TEXT: {
                data = mimeTypeData.text;
            }
        }
        int randomIndex = this.getRandom().nextInt(data.length);
        return data[randomIndex];
    }
}

