/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Isbn;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class IsbnGenerator
extends GenerationRule<Isbn, String> {
    public IsbnGenerator(Isbn annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
    }

    @Override
    public String generate() {
        String firstPart = this.randomPart(300);
        String secondPart = this.randomPart(300);
        String thirdPart = this.randomPart(300);
        String lastPart = this.charOrNumber();
        return String.format("%s%s%s-%s", firstPart, secondPart, thirdPart, lastPart);
    }

    private String randomPart(int range) {
        String random = String.valueOf(this.getRandom().nextInt(range));
        int targetLength = String.valueOf(range).length();
        int randomLength = random.length();
        if (randomLength < targetLength) {
            for (int i = randomLength; i < targetLength; ++i) {
                random = "0" + random;
            }
        }
        return random;
    }

    private String charOrNumber() {
        int random = this.getRandom().nextInt(38);
        if (random < 10) {
            return String.valueOf(random);
        }
        return this.getCharForNumber(random -= 10);
    }

    private String getCharForNumber(int i) {
        return i > 0 && i < 27 ? String.valueOf((char)(i + 64)) : "A";
    }
}

