/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.HexColor;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class HexColorGenerator
extends GenerationRule<HexColor, String> {
    public HexColorGenerator(HexColor annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
    }

    @Override
    public String generate() {
        String alpha = "";
        if (((HexColor)this.getAnnotation()).alpha()) {
            alpha = this.toHex(this.getRandom().nextInt(256));
        }
        String red = this.toHex(this.getRandom().nextInt(256));
        String green = this.toHex(this.getRandom().nextInt(256));
        String blue = this.toHex(this.getRandom().nextInt(256));
        String hexCode = String.format("#%s%s%s%s", alpha, red, green, blue);
        return ((HexColor)this.getAnnotation()).upperCase() ? hexCode.toUpperCase() : hexCode.toLowerCase();
    }

    private String toHex(int integer) {
        String hexString = Integer.toHexString(integer);
        switch (hexString.length()) {
            case 0: {
                hexString = "00";
                break;
            }
            case 1: {
                hexString = "0" + hexString;
            }
        }
        return hexString;
    }
}

