/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Encrypt;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.EncryptProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class EncryptGenerator
extends GenerationRule<Encrypt, String> {
    private EncryptProvider mProvider = this.providerFactory().provider(EncryptProvider.class, String[].class);
    private int mLength;

    public EncryptGenerator(Encrypt annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
        this.mLength = annotation.length();
        if (this.mLength < 0) {
            this.mLength = 0;
        }
    }

    @Override
    public String generate() {
        String randomizedText = this.randomizeEncryptedText();
        int textLength = randomizedText.length();
        int requiredLength = this.mLength;
        if (requiredLength == 0) {
            return "";
        }
        StringBuilder textBuilder = new StringBuilder();
        int loops = requiredLength / textLength;
        int leftOverLength = requiredLength % textLength;
        for (int i = 0; i < loops; ++i) {
            textBuilder.append(randomizedText.substring(0, textLength - 1));
        }
        textBuilder.append(randomizedText.substring(0, leftOverLength));
        return textBuilder.toString();
    }

    private String randomizeEncryptedText() {
        String[] encryptedLines = this.mProvider.provide();
        StringBuilder randomized = new StringBuilder();
        int length = encryptedLines.length;
        for (int i = 0; i < length; ++i) {
            int random = this.getRandom().nextInt(length);
            randomized.append(encryptedLines[random]);
        }
        return randomized.toString();
    }
}

