/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.generators;

import com.infoedge.jrandomizer.annotations.Email;
import com.infoedge.jrandomizer.generators.GenerationRule;
import com.infoedge.jrandomizer.providers.EmailProvider;
import com.infoedge.jrandomizer.providers.ProviderFactory;

public class EmailGenerator
extends GenerationRule<Email, String> {
    private EmailProvider mProvider = this.providerFactory().provider(EmailProvider.class, EmailProvider.EmailRecord[].class);

    public EmailGenerator(Email annotation, ProviderFactory providerFactory) {
        super(annotation, providerFactory);
    }

    @Override
    public String generate() {
        Email annotation = (Email)this.getAnnotation();
        if (annotation.in().length != 0) {
            String[] inEmailAddresses = annotation.in();
            int random = this.getRandom().nextInt(inEmailAddresses.length);
            return inEmailAddresses[random];
        }
        EmailProvider.EmailRecord[] emailRecords = (EmailProvider.EmailRecord[])this.mProvider.provide();
        int random = this.getRandom().nextInt(emailRecords.length);
        EmailProvider.EmailRecord emailRecord = emailRecords[random];
        String result = emailRecord.userName;
        if (annotation.domainName().length != 0) {
            random = this.getRandom().nextInt(annotation.domainName().length);
            String domainName = annotation.domainName()[random];
            result = result + "@" + domainName;
        } else {
            result = result + "@" + emailRecord.domainName;
        }
        return result;
    }
}

