/*
 * Decompiled with CFR 0.152.
 */
package com.infoedge.jrandomizer.annotations;

import com.infoedge.jrandomizer.adapters.StringToStringAdapter;
import com.infoedge.jrandomizer.annotations.GenerateUsing;
import com.infoedge.jrandomizer.annotations.Mapping;
import com.infoedge.jrandomizer.generators.MoneyGenerator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@GenerateUsing(generator=MoneyGenerator.class, mapping={@Mapping(fieldType=String.class, adapter=StringToStringAdapter.class)})
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface Money {
    public double min() default 0.0;

    public double max() default 100.0;

    public In in() default In.RANDOM;

    public static enum In {
        $("$"),
        \u20ac("\u20ac"),
        \u20b9("\u20b9"),
        RANDOM("random");

        private String currencySymbol;

        private In(String currency) {
            this.currencySymbol = currency;
        }

        public String getCurrencySymbol() {
            return this.currencySymbol;
        }
    }
}

