/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** SmsAdvancedTextualRequest */
public class SmsAdvancedTextualRequest {
  public static final String SERIALIZED_NAME_BULK_ID = "bulkId";

  @SerializedName(SERIALIZED_NAME_BULK_ID)
  private String bulkId;

  public static final String SERIALIZED_NAME_MESSAGES = "messages";

  @SerializedName(SERIALIZED_NAME_MESSAGES)
  private List<SmsTextualMessage> messages = null;

  public static final String SERIALIZED_NAME_SENDING_SPEED_LIMIT = "sendingSpeedLimit";

  @SerializedName(SERIALIZED_NAME_SENDING_SPEED_LIMIT)
  private SmsSendingSpeedLimit sendingSpeedLimit = null;

  public static final String SERIALIZED_NAME_TRACKING = "tracking";

  @SerializedName(SERIALIZED_NAME_TRACKING)
  private SmsTracking tracking = null;

  public SmsAdvancedTextualRequest bulkId(String bulkId) {

    this.bulkId = bulkId;
    return this;
  }

  /**
   * The ID which uniquely identifies the request. Bulk ID will be received only when you send a
   * message to more than one destination address.
   *
   * @return bulkId
   */
  public String getBulkId() {
    return bulkId;
  }

  public void setBulkId(String bulkId) {
    this.bulkId = bulkId;
  }

  public SmsAdvancedTextualRequest messages(List<SmsTextualMessage> messages) {

    this.messages = messages;
    return this;
  }

  public SmsAdvancedTextualRequest addMessagesItem(SmsTextualMessage messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<>();
    }
    this.messages.add(messagesItem);
    return this;
  }

  /**
   * Get messages
   *
   * @return messages
   */
  public List<SmsTextualMessage> getMessages() {
    return messages;
  }

  public void setMessages(List<SmsTextualMessage> messages) {
    this.messages = messages;
  }

  public SmsAdvancedTextualRequest sendingSpeedLimit(SmsSendingSpeedLimit sendingSpeedLimit) {

    this.sendingSpeedLimit = sendingSpeedLimit;
    return this;
  }

  /**
   * Limit the sending speed for message bulks. In some use cases, you might want to reduce message
   * sending speed if your message call to action involves visiting a website, calling your contact
   * center or similar recipient activity, in which you can handle a limited amount of load. This
   * setting helps you to spread the delivery of the messages over a longer period, allowing your
   * systems or agents to handle incoming traffic in real-time, resulting in better customer
   * satisfaction.
   *
   * @return sendingSpeedLimit
   */
  public SmsSendingSpeedLimit getSendingSpeedLimit() {
    return sendingSpeedLimit;
  }

  public void setSendingSpeedLimit(SmsSendingSpeedLimit sendingSpeedLimit) {
    this.sendingSpeedLimit = sendingSpeedLimit;
  }

  public SmsAdvancedTextualRequest tracking(SmsTracking tracking) {

    this.tracking = tracking;
    return this;
  }

  /**
   * Get tracking
   *
   * @return tracking
   */
  public SmsTracking getTracking() {
    return tracking;
  }

  public void setTracking(SmsTracking tracking) {
    this.tracking = tracking;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsAdvancedTextualRequest smsAdvancedTextualRequest = (SmsAdvancedTextualRequest) o;
    return Objects.equals(this.bulkId, smsAdvancedTextualRequest.bulkId)
        && Objects.equals(this.messages, smsAdvancedTextualRequest.messages)
        && Objects.equals(this.sendingSpeedLimit, smsAdvancedTextualRequest.sendingSpeedLimit)
        && Objects.equals(this.tracking, smsAdvancedTextualRequest.tracking);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bulkId, messages, sendingSpeedLimit, tracking);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsAdvancedTextualRequest {\n");
    sb.append("    bulkId: ").append(toIndentedString(bulkId)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    sendingSpeedLimit: ").append(toIndentedString(sendingSpeedLimit)).append("\n");
    sb.append("    tracking: ").append(toIndentedString(tracking)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
