/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import com.infobip.model.SmsInboundMessageResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReceiveSmsApi {
  private ApiClient localVarApiClient;

  public ReceiveSmsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ReceiveSmsApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  /**
   * Build call for getInboundSmsMessages.
   *
   * @param limit Maximal number of received messages that will be returned. (optional)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public okhttp3.Call getInboundSmsMessagesCall(Integer limit, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/sms/1/inbox/reports";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (limit != null) {
      localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
    }

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json", "application/xml"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getInboundSmsMessagesValidateBeforeCall(
      Integer limit, final ApiCallback _callback) throws ApiException {

    okhttp3.Call localVarCall = getInboundSmsMessagesCall(limit, _callback);
    return localVarCall;
  }

  /**
   * Get inbound SMS messages. If for some reason you are unable to receive incoming SMS at the
   * endpoint of your choice in real time, you can use this API call to fetch messages. Each request
   * will return a batch of received messages - only once. The following API request will return
   * only new messages that arrived since the last API request.
   *
   * @param limit Maximal number of received messages that will be returned. (optional)
   * @return SmsInboundMessageResult
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public SmsInboundMessageResult getInboundSmsMessages(Integer limit) throws ApiException {
    ApiResponse<SmsInboundMessageResult> localVarResp = getInboundSmsMessagesWithHttpInfo(limit);
    return localVarResp.getData();
  }

  /**
   * Get inbound SMS messages. If for some reason you are unable to receive incoming SMS at the
   * endpoint of your choice in real time, you can use this API call to fetch messages. Each request
   * will return a batch of received messages - only once. The following API request will return
   * only new messages that arrived since the last API request.
   *
   * @param limit Maximal number of received messages that will be returned. (optional)
   * @return ApiResponse&lt;SmsInboundMessageResult&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<SmsInboundMessageResult> getInboundSmsMessagesWithHttpInfo(Integer limit)
      throws ApiException {
    okhttp3.Call localVarCall = getInboundSmsMessagesValidateBeforeCall(limit, null);
    Type localVarReturnType = new TypeToken<SmsInboundMessageResult>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get inbound SMS messages (asynchronously). If for some reason you are unable to receive
   * incoming SMS at the endpoint of your choice in real time, you can use this API call to fetch
   * messages. Each request will return a batch of received messages - only once. The following API
   * request will return only new messages that arrived since the last API request.
   *
   * @param limit Maximal number of received messages that will be returned. (optional)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public okhttp3.Call getInboundSmsMessagesAsync(
      Integer limit, final ApiCallback<SmsInboundMessageResult> _callback) throws ApiException {

    okhttp3.Call localVarCall = getInboundSmsMessagesValidateBeforeCall(limit, _callback);
    Type localVarReturnType = new TypeToken<SmsInboundMessageResult>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
