/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * LineProtocolError
 */

public class LineProtocolError {
  /**
   * Code is the machine-readable error code.
   */
  @JsonAdapter(CodeEnum.Adapter.class)
  public enum CodeEnum {
    INTERNAL_ERROR("internal error"),
    
    NOT_FOUND("not found"),
    
    CONFLICT("conflict"),
    
    INVALID("invalid"),
    
    EMPTY_VALUE("empty value"),
    
    UNAVAILABLE("unavailable");

    private String value;

    CodeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CodeEnum fromValue(String text) {
      for (CodeEnum b : CodeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<CodeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CodeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CodeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return CodeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_CODE = "code";
  @SerializedName(SERIALIZED_NAME_CODE)
  private CodeEnum code;

  public static final String SERIALIZED_NAME_MESSAGE = "message";
  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private String message;

  public static final String SERIALIZED_NAME_OP = "op";
  @SerializedName(SERIALIZED_NAME_OP)
  private String op;

  public static final String SERIALIZED_NAME_ERR = "err";
  @SerializedName(SERIALIZED_NAME_ERR)
  private String err;

  public static final String SERIALIZED_NAME_LINE = "line";
  @SerializedName(SERIALIZED_NAME_LINE)
  private Integer line;

   /**
   * Code is the machine-readable error code.
   * @return code
  **/
  public CodeEnum getCode() {
    return code;
  }

   /**
   * Human-readable message.
   * @return message
  **/
  public String getMessage() {
    return message;
  }

   /**
   * Describes the logical code operation when the error occurred. Useful for debugging.
   * @return op
  **/
  public String getOp() {
    return op;
  }

   /**
   * Stack of errors that occurred during processing of the request. Useful for debugging.
   * @return err
  **/
  public String getErr() {
    return err;
  }

   /**
   * First line in the request body that contains malformed data.
   * @return line
  **/
  public Integer getLine() {
    return line;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineProtocolError lineProtocolError = (LineProtocolError) o;
    return Objects.equals(this.code, lineProtocolError.code) &&
        Objects.equals(this.message, lineProtocolError.message) &&
        Objects.equals(this.op, lineProtocolError.op) &&
        Objects.equals(this.err, lineProtocolError.err) &&
        Objects.equals(this.line, lineProtocolError.line);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, op, err, line);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineProtocolError {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    op: ").append(toIndentedString(op)).append("\n");
    sb.append("    err: ").append(toIndentedString(err)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

