/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.DashboardQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * SimpleTableViewProperties
 */

public class SimpleTableViewProperties extends ViewProperties {
  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    SIMPLE_TABLE("simple-table");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type = TypeEnum.SIMPLE_TABLE;

  public static final String SERIALIZED_NAME_SHOW_ALL = "showAll";
  @SerializedName(SERIALIZED_NAME_SHOW_ALL)
  private Boolean showAll;

  public static final String SERIALIZED_NAME_QUERIES = "queries";
  @SerializedName(SERIALIZED_NAME_QUERIES)
  private List<DashboardQuery> queries = new ArrayList<>();

  /**
   * Gets or Sets shape
   */
  @JsonAdapter(ShapeEnum.Adapter.class)
  public enum ShapeEnum {
    CHRONOGRAF_V2("chronograf-v2");

    private String value;

    ShapeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ShapeEnum fromValue(String text) {
      for (ShapeEnum b : ShapeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ShapeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ShapeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ShapeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return ShapeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_SHAPE = "shape";
  @SerializedName(SERIALIZED_NAME_SHAPE)
  private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;

  public static final String SERIALIZED_NAME_NOTE = "note";
  @SerializedName(SERIALIZED_NAME_NOTE)
  private String note;

  public static final String SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY = "showNoteWhenEmpty";
  @SerializedName(SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY)
  private Boolean showNoteWhenEmpty;

   /**
   * Get type
   * @return type
  **/
  public TypeEnum getType() {
    return type;
  }

  public SimpleTableViewProperties showAll(Boolean showAll) {
    this.showAll = showAll;
    return this;
  }

   /**
   * Get showAll
   * @return showAll
  **/
  public Boolean getShowAll() {
    return showAll;
  }

  public void setShowAll(Boolean showAll) {
    this.showAll = showAll;
  }

  public SimpleTableViewProperties queries(List<DashboardQuery> queries) {
    this.queries = queries;
    return this;
  }

  public SimpleTableViewProperties addQueriesItem(DashboardQuery queriesItem) {
    this.queries.add(queriesItem);
    return this;
  }

   /**
   * Get queries
   * @return queries
  **/
  public List<DashboardQuery> getQueries() {
    return queries;
  }

  public void setQueries(List<DashboardQuery> queries) {
    this.queries = queries;
  }

   /**
   * Get shape
   * @return shape
  **/
  public ShapeEnum getShape() {
    return shape;
  }

  public SimpleTableViewProperties note(String note) {
    this.note = note;
    return this;
  }

   /**
   * Get note
   * @return note
  **/
  public String getNote() {
    return note;
  }

  public void setNote(String note) {
    this.note = note;
  }

  public SimpleTableViewProperties showNoteWhenEmpty(Boolean showNoteWhenEmpty) {
    this.showNoteWhenEmpty = showNoteWhenEmpty;
    return this;
  }

   /**
   * If true, will display note when empty
   * @return showNoteWhenEmpty
  **/
  public Boolean getShowNoteWhenEmpty() {
    return showNoteWhenEmpty;
  }

  public void setShowNoteWhenEmpty(Boolean showNoteWhenEmpty) {
    this.showNoteWhenEmpty = showNoteWhenEmpty;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimpleTableViewProperties simpleTableViewProperties = (SimpleTableViewProperties) o;
    return Objects.equals(this.type, simpleTableViewProperties.type) &&
        Objects.equals(this.showAll, simpleTableViewProperties.showAll) &&
        Objects.equals(this.queries, simpleTableViewProperties.queries) &&
        Objects.equals(this.shape, simpleTableViewProperties.shape) &&
        Objects.equals(this.note, simpleTableViewProperties.note) &&
        Objects.equals(this.showNoteWhenEmpty, simpleTableViewProperties.showNoteWhenEmpty) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, showAll, queries, shape, note, showNoteWhenEmpty, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimpleTableViewProperties {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    showAll: ").append(toIndentedString(showAll)).append("\n");
    sb.append("    queries: ").append(toIndentedString(queries)).append("\n");
    sb.append("    shape: ").append(toIndentedString(shape)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    showNoteWhenEmpty: ").append(toIndentedString(showNoteWhenEmpty)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

