/*
 * Influx OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.CellLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Cell
 */

public class Cell {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_LINKS = "links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private CellLinks links = null;

  public static final String SERIALIZED_NAME_X = "x";
  @SerializedName(SERIALIZED_NAME_X)
  private Integer x;

  public static final String SERIALIZED_NAME_Y = "y";
  @SerializedName(SERIALIZED_NAME_Y)
  private Integer y;

  public static final String SERIALIZED_NAME_W = "w";
  @SerializedName(SERIALIZED_NAME_W)
  private Integer w;

  public static final String SERIALIZED_NAME_H = "h";
  @SerializedName(SERIALIZED_NAME_H)
  private Integer h;

  public static final String SERIALIZED_NAME_VIEW_I_D = "viewID";
  @SerializedName(SERIALIZED_NAME_VIEW_I_D)
  private String viewID;

  public Cell id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Cell links(CellLinks links) {
    this.links = links;
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @ApiModelProperty(value = "")
  public CellLinks getLinks() {
    return links;
  }

  public void setLinks(CellLinks links) {
    this.links = links;
  }

  public Cell x(Integer x) {
    this.x = x;
    return this;
  }

   /**
   * Get x
   * @return x
  **/
  @ApiModelProperty(value = "")
  public Integer getX() {
    return x;
  }

  public void setX(Integer x) {
    this.x = x;
  }

  public Cell y(Integer y) {
    this.y = y;
    return this;
  }

   /**
   * Get y
   * @return y
  **/
  @ApiModelProperty(value = "")
  public Integer getY() {
    return y;
  }

  public void setY(Integer y) {
    this.y = y;
  }

  public Cell w(Integer w) {
    this.w = w;
    return this;
  }

   /**
   * Get w
   * @return w
  **/
  @ApiModelProperty(value = "")
  public Integer getW() {
    return w;
  }

  public void setW(Integer w) {
    this.w = w;
  }

  public Cell h(Integer h) {
    this.h = h;
    return this;
  }

   /**
   * Get h
   * @return h
  **/
  @ApiModelProperty(value = "")
  public Integer getH() {
    return h;
  }

  public void setH(Integer h) {
    this.h = h;
  }

  public Cell viewID(String viewID) {
    this.viewID = viewID;
    return this;
  }

   /**
   * The reference to a view from the views API.
   * @return viewID
  **/
  @ApiModelProperty(value = "The reference to a view from the views API.")
  public String getViewID() {
    return viewID;
  }

  public void setViewID(String viewID) {
    this.viewID = viewID;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Cell cell = (Cell) o;
    return Objects.equals(this.id, cell.id) &&
        Objects.equals(this.links, cell.links) &&
        Objects.equals(this.x, cell.x) &&
        Objects.equals(this.y, cell.y) &&
        Objects.equals(this.w, cell.w) &&
        Objects.equals(this.h, cell.h) &&
        Objects.equals(this.viewID, cell.viewID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, links, x, y, w, h, viewID);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Cell {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    x: ").append(toIndentedString(x)).append("\n");
    sb.append("    y: ").append(toIndentedString(y)).append("\n");
    sb.append("    w: ").append(toIndentedString(w)).append("\n");
    sb.append("    h: ").append(toIndentedString(h)).append("\n");
    sb.append("    viewID: ").append(toIndentedString(viewID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

