/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.internal.InfluxDBClientImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import okhttp3.Cookie;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class AuthenticateInterceptor
implements Interceptor {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private static final List<String> NO_AUTH_ROUTE = Arrays.asList("/api/v2/signin", "/api/v2/signout", "/api/v2/setup");
    private final InfluxDBClientOptions influxDBClientOptions;
    private OkHttpClient okHttpClient;
    private char[] sessionToken;
    private AtomicBoolean signout = new AtomicBoolean(false);

    AuthenticateInterceptor(@Nonnull InfluxDBClientOptions influxDBClientOptions) {
        Arguments.checkNotNull((Object)influxDBClientOptions, (String)"InfluxDBClientOptions");
        this.influxDBClientOptions = influxDBClientOptions;
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String requestPath = request.url().encodedPath();
        if (NO_AUTH_ROUTE.stream().anyMatch(requestPath::endsWith) || this.signout.get()) {
            return chain.proceed(request);
        }
        if (InfluxDBClientOptions.AuthScheme.TOKEN.equals((Object)this.influxDBClientOptions.getAuthScheme())) {
            request = request.newBuilder().header("Authorization", "Token " + this.string(this.influxDBClientOptions.getToken())).build();
        } else if (InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme())) {
            this.initToken(this.okHttpClient);
            if (this.sessionToken != null) {
                request = request.newBuilder().header("Cookie", "session=" + this.string(this.sessionToken)).build();
            }
        }
        return chain.proceed(request);
    }

    void initToken(@Nonnull OkHttpClient okHttpClient) {
        Arguments.checkNotNull((Object)okHttpClient, (String)"okHttpClient");
        this.okHttpClient = okHttpClient;
        if (!InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme()) || this.signout.get()) {
            return;
        }
        if (this.sessionToken == null) {
            String credentials = Credentials.basic((String)this.influxDBClientOptions.getUsername(), (String)this.string(this.influxDBClientOptions.getPassword()));
            Request authRequest = new Request.Builder().url(this.buildPath("api/v2/signin")).addHeader("Authorization", credentials).post(RequestBody.create(null, (String)"")).build();
            try (Response authResponse = this.okHttpClient.newCall(authRequest).execute();){
                Cookie sessionCookie = Cookie.parseAll((HttpUrl)authRequest.url(), (Headers)authResponse.headers()).stream().filter(cookie -> "session".equals(cookie.name())).findFirst().orElse(null);
                if (sessionCookie != null) {
                    this.sessionToken = sessionCookie.value().toCharArray();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Cannot retrieve the Session token!", e);
            }
        }
    }

    void signout() throws IOException {
        if (!InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme()) || this.signout.get()) {
            this.signout.set(true);
            return;
        }
        this.signout.set(true);
        this.sessionToken = null;
        Request authRequest = new Request.Builder().url(this.buildPath("api/v2/signout")).post(RequestBody.create(null, (String)"")).build();
        Response response = this.okHttpClient.newCall(authRequest).execute();
        response.close();
    }

    @Nonnull
    String buildPath(String buildPath) {
        Arguments.checkNotNull((Object)buildPath, (String)"buildPath");
        return HttpUrl.parse((String)this.influxDBClientOptions.getUrl()).newBuilder().addEncodedPathSegments(buildPath).build().toString();
    }

    @Nonnull
    private String string(char[] password) {
        return String.valueOf(password);
    }
}

