/*
 * Influx API Service
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.ImportDeclaration;
import com.influxdb.client.domain.PackageClause;
import com.influxdb.client.domain.Statement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents a source from a single file
 */
@ApiModel(description = "Represents a source from a single file")

public class File {
  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_PACKAGE = "package";
  @SerializedName(SERIALIZED_NAME_PACKAGE)
  private PackageClause _package = null;

  public static final String SERIALIZED_NAME_IMPORTS = "imports";
  @SerializedName(SERIALIZED_NAME_IMPORTS)
  private List<ImportDeclaration> imports = new ArrayList<>();

  public static final String SERIALIZED_NAME_BODY = "body";
  @SerializedName(SERIALIZED_NAME_BODY)
  @JsonAdapter(FileBodyAdapter.class)
  private List<Statement> body = new ArrayList<>();

  public File type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Type of AST node
   * @return type
  **/
  @ApiModelProperty(value = "Type of AST node")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public File name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the file.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the file.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public File _package(PackageClause _package) {
    this._package = _package;
    return this;
  }

   /**
   * Get _package
   * @return _package
  **/
  @ApiModelProperty(value = "")
  public PackageClause getPackage() {
    return _package;
  }

  public void setPackage(PackageClause _package) {
    this._package = _package;
  }

  public File imports(List<ImportDeclaration> imports) {
    this.imports = imports;
    return this;
  }

  public File addImportsItem(ImportDeclaration importsItem) {
    if (this.imports == null) {
      this.imports = new ArrayList<>();
    }
    this.imports.add(importsItem);
    return this;
  }

   /**
   * A list of package imports
   * @return imports
  **/
  @ApiModelProperty(value = "A list of package imports")
  public List<ImportDeclaration> getImports() {
    return imports;
  }

  public void setImports(List<ImportDeclaration> imports) {
    this.imports = imports;
  }

  public File body(List<Statement> body) {
    this.body = body;
    return this;
  }

  public File addBodyItem(Statement bodyItem) {
    if (this.body == null) {
      this.body = new ArrayList<>();
    }
    this.body.add(bodyItem);
    return this;
  }

   /**
   * List of Flux statements
   * @return body
  **/
  @ApiModelProperty(value = "List of Flux statements")
  public List<Statement> getBody() {
    return body;
  }

  public void setBody(List<Statement> body) {
    this.body = body;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    File file = (File) o;
    return Objects.equals(this.type, file.type) &&
        Objects.equals(this.name, file.name) &&
        Objects.equals(this._package, file._package) &&
        Objects.equals(this.imports, file.imports) &&
        Objects.equals(this.body, file.body);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, _package, imports, body);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class File {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    _package: ").append(toIndentedString(_package)).append("\n");
    sb.append("    imports: ").append(toIndentedString(imports)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public class FileBodyAdapter implements JsonDeserializer<Object>, JsonSerializer<Object> {

    public FileBodyAdapter() {
    }

    @Override
    public Object deserialize(final JsonElement json, final Type typeOfT, final JsonDeserializationContext context) throws JsonParseException {

      List<String> discriminator = Arrays.asList("type");

      List<Object> results = new ArrayList<>();

      for (JsonElement arrayItem: json.getAsJsonArray()){
        JsonObject jsonObject = arrayItem.getAsJsonObject();

        String[] types = discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);

        results.add(deserialize(types, jsonObject, context));
      }

      return results;
    }

    @Override
    public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {

      return context.serialize(object);
    }

    private Object deserialize(final String[] types, final JsonElement json, final JsonDeserializationContext context) {

      if (Arrays.equals(new String[]{ "BadStatement" }, types)) {
        return context.deserialize(json, BadStatement.class);
      }
      if (Arrays.equals(new String[]{ "VariableAssignment" }, types)) {
        return context.deserialize(json, VariableAssignment.class);
      }
      if (Arrays.equals(new String[]{ "MemberAssignment" }, types)) {
        return context.deserialize(json, MemberAssignment.class);
      }
      if (Arrays.equals(new String[]{ "ExpressionStatement" }, types)) {
        return context.deserialize(json, ExpressionStatement.class);
      }
      if (Arrays.equals(new String[]{ "ReturnStatement" }, types)) {
        return context.deserialize(json, ReturnStatement.class);
      }
      if (Arrays.equals(new String[]{ "OptionStatement" }, types)) {
        return context.deserialize(json, OptionStatement.class);
      }
      if (Arrays.equals(new String[]{ "BuiltinStatement" }, types)) {
        return context.deserialize(json, BuiltinStatement.class);
      }
      if (Arrays.equals(new String[]{ "TestStatement" }, types)) {
        return context.deserialize(json, TestStatement.class);
      }

      return context.deserialize(json, Object.class);
    }
  }
}

