/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.jni;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class NativeUtils {
    private static final Logger logger = Logger.getLogger(NativeUtils.class);

    private NativeUtils() {
    }

    private static String getOsFamily() throws IOException {
        String osFamily;
        int jvmBitness = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().contains("mac")) {
            osFamily = "Darwin";
        } else if (osName.toLowerCase().contains("linux")) {
            osFamily = "Linux";
        } else {
            throw new IllegalStateException("Unsupported operating system " + osName + " " + jvmBitness);
        }
        switch (jvmBitness) {
            case 64: {
                return osFamily;
            }
            case 32: {
                return osFamily + ".32";
            }
        }
        throw new IllegalStateException("Unsupported operating system " + osName + " " + jvmBitness);
    }

    public static void loadOSDependentLibrary(String path, String suffix) throws IOException {
        String osFamily = NativeUtils.getOsFamily();
        String osDependentLib = null;
        String currentOsDependentLib = path + "." + osFamily + suffix;
        if (NativeUtils.class.getResource(currentOsDependentLib) != null) {
            osDependentLib = currentOsDependentLib;
        }
        if (osDependentLib != null) {
            logger.info((Object)("Loading " + osDependentLib));
            NativeUtils.loadLibraryFromJar(osDependentLib);
        } else {
            logger.info((Object)("Loading " + path + suffix));
            NativeUtils.loadLibraryFromJar(path + suffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws IOException {
        File[] tmpFiles;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeUtils.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        System.load(temp.getAbsolutePath());
        final String libraryPrefix = prefix;
        String lockSuffix = ".lock";
        File lock = new File(temp.getAbsolutePath() + ".lock");
        lock.createNewFile();
        lock.deleteOnExit();
        FileFilter tmpDirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(libraryPrefix) && !pathname.getName().endsWith(".lock");
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        for (File tmpFile : tmpFiles = tmpDir.listFiles(tmpDirFilter)) {
            File lockFile = new File(tmpFile.getAbsolutePath() + ".lock");
            if (lockFile.exists()) continue;
            tmpFile.delete();
        }
    }
}

