/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.progvalidation;

import com.indeed.vw.wrapper.progvalidation.ProgressiveValidation;

public class LogLossValidation
extends ProgressiveValidation {
    private double logLikelihood = 0.0;
    private int count = 0;

    public LogLossValidation() {
        super("LOG-LOSS", false);
    }

    @Override
    public synchronized double getScore() {
        if (this.count == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -this.logLikelihood / (double)this.count;
    }

    @Override
    public synchronized void updateScore(double prediction, double actual) {
        double constrainedPrediction = Math.max(1.0E-7, Math.min(0.9999999, prediction));
        this.logLikelihood = actual > 0.0 ? (this.logLikelihood += Math.log(constrainedPrediction)) : (this.logLikelihood += Math.log(1.0 - constrainedPrediction));
        ++this.count;
    }
}

