/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.array;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.indeed.util.serialization.Stringifier;
import com.indeed.util.serialization.splitter.EscapeAwareSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CharArrayStringifier
implements Stringifier<char[]> {
    private static final Logger log = LoggerFactory.getLogger(CharArrayStringifier.class);

    @Override
    public String toString(char[] chars) {
        return Arrays.toString(chars);
    }

    @Override
    public char[] fromString(String str) {
        ArrayList chars = Lists.newArrayList();
        EscapeAwareSplitter splitter = new EscapeAwareSplitter(CharMatcher.whitespace().or(CharMatcher.is((char)',')), EscapeAwareSplitter.NO_ESCAPE_LEXER_SUPPLIER);
        Iterator<String> split = splitter.split(str.substring(1, str.length() - 1));
        while (split.hasNext()) {
            chars.add(Character.valueOf(split.next().charAt(0)));
        }
        char[] ret = new char[chars.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((Character)chars.get(i)).charValue();
        }
        return ret;
    }
}

