/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.array;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.indeed.util.serialization.Stringifier;
import com.indeed.util.serialization.splitter.EscapeAwareSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class ShortArrayStringifier
implements Stringifier<short[]> {
    private static final Logger log = Logger.getLogger(ShortArrayStringifier.class);

    @Override
    public String toString(short[] shorts) {
        return Arrays.toString(shorts);
    }

    @Override
    public short[] fromString(String str) {
        ArrayList shorts = Lists.newArrayList();
        EscapeAwareSplitter splitter = new EscapeAwareSplitter(CharMatcher.whitespace().or(CharMatcher.is((char)',')), EscapeAwareSplitter.NO_ESCAPE_LEXER_SUPPLIER);
        Iterator<String> split = splitter.split(str.substring(1, str.length() - 1));
        while (split.hasNext()) {
            shorts.add(Short.parseShort(split.next()));
        }
        short[] ret = new short[shorts.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Short)shorts.get(i);
        }
        return ret;
    }
}

