/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.array;

import com.indeed.util.serialization.Stringifier;
import com.indeed.util.serialization.list.ListStringifier;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class ObjectArrayStringifier<E>
implements Stringifier<E[]> {
    private static final Logger log = Logger.getLogger(ObjectArrayStringifier.class);
    private final ListStringifier<E> listStringifier;
    private final Class<E> type;

    public ObjectArrayStringifier(Stringifier<E> stringifier, Class<E> type) {
        this.listStringifier = ListStringifier.arrayListStringifier(stringifier);
        this.type = type;
    }

    @Override
    public String toString(E[] objects) {
        return this.listStringifier.toString(Arrays.asList(objects));
    }

    @Override
    public E[] fromString(String str) {
        Object values = this.listStringifier.fromString(str);
        return values.toArray((Object[])Array.newInstance(this.type, values.size()));
    }
}

