/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization;

import com.indeed.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class VarULongSerializer
implements Serializer<Long> {
    private static final Logger log = Logger.getLogger(VarULongSerializer.class);
    private static final long MAX_31 = Integer.MAX_VALUE;
    public static final int HIGH_BIT = Integer.MIN_VALUE;
    public long INT_MASK = 0xFFFFFFFFL;

    @Override
    public void write(Long l, DataOutput out) throws IOException {
        if (l <= Integer.MAX_VALUE) {
            out.writeInt(l.intValue());
        } else {
            out.writeInt((int)(l >>> 32) | Integer.MIN_VALUE);
            out.writeInt(l.intValue());
        }
    }

    @Override
    public Long read(DataInput in) throws IOException {
        int first = in.readInt();
        if (first >= 0) {
            return first;
        }
        return ((long)first & Integer.MAX_VALUE) << 32 | (long)in.readInt() & this.INT_MASK;
    }
}

