/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.set;

import com.google.common.base.Supplier;
import com.indeed.util.serialization.CollectionSuppliers;
import com.indeed.util.serialization.LengthVIntSerializer;
import com.indeed.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SetSerializer<E>
implements Serializer<Set<E>> {
    private static final Logger log = Logger.getLogger(SetSerializer.class);
    private static final LengthVIntSerializer lengthSerializer = new LengthVIntSerializer();
    private final Serializer<E> elementSerializer;
    private final Supplier<Set<E>> setSupplier;

    public static <E> SetSerializer<E> hashSetSerializer(Serializer<E> serializer) {
        return new SetSerializer<E>(new CollectionSuppliers.HashSetSupplier(), serializer);
    }

    public SetSerializer(Supplier<Set<E>> setSupplier, Serializer<E> elementSerializer) {
        this.elementSerializer = elementSerializer;
        this.setSupplier = setSupplier;
    }

    @Override
    public void write(Set<E> es, DataOutput out) throws IOException {
        lengthSerializer.write(es.size(), out);
        for (E e : es) {
            this.elementSerializer.write(e, out);
        }
    }

    @Override
    public Set<E> read(DataInput in) throws IOException {
        int length = lengthSerializer.read(in);
        Set ret = (Set)this.setSupplier.get();
        for (int i = 0; i < length; ++i) {
            ret.add(this.elementSerializer.read(in));
        }
        return ret;
    }
}

