/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.splitter;

import com.google.common.base.CharMatcher;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public final class EscapeAwareSplitter {
    private static final Logger log = Logger.getLogger(EscapeAwareSplitter.class);
    public static final Supplier<Lexer> NO_ESCAPE_LEXER_SUPPLIER = new Supplier<Lexer>(){

        public Lexer get() {
            return new Lexer(){
                String str;
                CharMatcher delimiter;
                int startIndex = -1;
                int endIndex = 0;

                @Override
                public void setInput(String str) {
                    this.str = str;
                }

                @Override
                public void setDelimiter(CharMatcher delimiter) {
                    this.delimiter = delimiter;
                }

                @Override
                public boolean accept(int index) throws ParseException {
                    char c = this.str.charAt(index);
                    if (this.startIndex < 0) {
                        this.startIndex = index;
                    }
                    if (this.delimiter.matches(c)) {
                        return false;
                    }
                    this.endIndex = index + 1;
                    return true;
                }

                @Override
                public void reset() {
                    this.startIndex = -1;
                    this.endIndex = 0;
                }

                @Override
                public String get() throws ParseException {
                    if (this.startIndex < 0) {
                        throw new IllegalStateException("this shouldn't happen");
                    }
                    return this.str.substring(this.startIndex, this.endIndex);
                }
            };
        }
    };
    public static final Supplier<Lexer> ESCAPE_JAVA_LEXER_SUPPLIER = new Supplier<Lexer>(){

        public Lexer get() {
            return new Lexer(){
                String str;
                CharMatcher delimiter;
                StringBuilder builder = new StringBuilder();
                int startIndex = -1;
                int endIndex = 0;
                boolean quoted = false;
                boolean escaped = false;

                @Override
                public void setInput(String str) {
                    this.str = str;
                }

                @Override
                public void setDelimiter(CharMatcher delimiter) {
                    this.delimiter = delimiter;
                }

                @Override
                public boolean accept(int index) throws ParseException {
                    char c = this.str.charAt(index);
                    if (this.startIndex < 0) {
                        this.startIndex = index;
                    }
                    if (this.escaped) {
                        this.escaped = false;
                    } else {
                        if (!this.quoted && this.delimiter.matches(c)) {
                            return false;
                        }
                        if (c == '\\') {
                            this.escaped = true;
                        }
                        if (c == '\"') {
                            this.builder.append(StringEscapeUtils.unescapeJava((String)this.str.substring(this.startIndex, index)));
                            this.startIndex = index + 1;
                            this.quoted = !this.quoted;
                        }
                    }
                    this.endIndex = index + 1;
                    return true;
                }

                @Override
                public void reset() {
                    this.startIndex = -1;
                    this.endIndex = 0;
                    this.quoted = false;
                    this.escaped = false;
                    this.builder.setLength(0);
                }

                @Override
                public String get() throws ParseException {
                    if (this.quoted) {
                        throw new ParseException("quote not closed");
                    }
                    if (this.escaped) {
                        throw new ParseException("improper escape");
                    }
                    if (this.startIndex < 0) {
                        throw new IllegalStateException("this shouldn't happen");
                    }
                    this.builder.append(StringEscapeUtils.unescapeJava((String)this.str.substring(this.startIndex, this.endIndex)));
                    return this.builder.toString();
                }
            };
        }
    };
    private final CharMatcher delimiter;
    private final Supplier<Lexer> lexerSupplier;

    public EscapeAwareSplitter(CharMatcher delimiter, Supplier<Lexer> lexerSupplier) {
        this.delimiter = delimiter;
        this.lexerSupplier = lexerSupplier;
    }

    public Iterator<String> split(final String str) {
        return new AbstractIterator<String>(){
            int index = 0;
            Lexer lexer = (Lexer)EscapeAwareSplitter.access$000(EscapeAwareSplitter.this).get();
            {
                this.lexer.setInput(str);
                this.lexer.setDelimiter(EscapeAwareSplitter.this.delimiter);
            }

            protected String computeNext() {
                if (this.index >= str.length()) {
                    this.endOfData();
                    return null;
                }
                try {
                    while (this.index < str.length() && EscapeAwareSplitter.this.delimiter.matches(str.charAt(this.index))) {
                        ++this.index;
                    }
                    boolean matched = false;
                    while (this.index < str.length() && this.lexer.accept(this.index)) {
                        matched = true;
                        ++this.index;
                    }
                    if (matched) {
                        String ret = this.lexer.get();
                        this.lexer.reset();
                        ++this.index;
                        return ret;
                    }
                    this.endOfData();
                    return null;
                }
                catch (ParseException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    static /* synthetic */ Supplier access$000(EscapeAwareSplitter x0) {
        return x0.lexerSupplier;
    }

    public static final class ParseException
    extends Exception {
        public ParseException() {
        }

        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }

    public static interface Lexer {
        public void setInput(String var1);

        public void setDelimiter(CharMatcher var1);

        public boolean accept(int var1) throws ParseException;

        public void reset();

        public String get() throws ParseException;
    }
}

