/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.indeed.util.core.DataLoadTimer;
import com.indeed.util.core.HasDataLoadingVariables;
import com.indeed.util.varexport.VarExporter;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public abstract class DataLoadingTimerTask
extends TimerTask
implements HasDataLoadingVariables {
    private static final Logger log = Logger.getLogger(DataLoadingTimerTask.class);
    protected DataLoadTimer dataLoadTimer = new DataLoadTimer();
    private String dataVersion;

    public DataLoadingTimerTask(String namespace) {
        VarExporter.forNamespace((String)namespace).includeInGlobal().export((Object)this, "");
    }

    public void setDataVersion(String version) {
        this.dataVersion = version;
    }

    @Override
    public String getDataVersion() {
        return this.dataVersion;
    }

    protected void loadFailed() {
        this.dataLoadTimer.loadFailed();
    }

    protected void loadComplete() {
        this.dataLoadTimer.loadComplete();
    }

    public abstract boolean load();

    @Override
    public Integer getSecondsSinceLastLoad() {
        return this.dataLoadTimer.getSecondsSinceLastLoad();
    }

    @Override
    public Integer getSecondsSinceLastFailedLoad() {
        return this.dataLoadTimer.getSecondsSinceLastFailedLoad();
    }

    @Override
    public Integer getSecondsSinceLastLoadCheck() {
        return this.dataLoadTimer.getSecondsSinceLastLoadCheck();
    }

    @Override
    public final void run() {
        try {
            this.dataLoadTimer.updateLastLoadCheck();
            if (this.load()) {
                this.loadComplete();
            }
        }
        catch (RuntimeException e) {
            this.loadFailed();
            log.error((Object)"Ignoring RuntimeException", (Throwable)e);
        }
        catch (Error e) {
            this.loadFailed();
            log.error((Object)"Ignoring Error", (Throwable)e);
        }
    }
}

