/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.reference;

import com.google.common.base.Function;
import com.indeed.util.core.io.Closeables2;
import com.indeed.util.core.reference.SharedReference;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class AtomicSharedReference<T> {
    private static final Logger log = Logger.getLogger(AtomicSharedReference.class);
    private SharedReference<T> ref;

    public static <T> AtomicSharedReference<T> create() {
        return new AtomicSharedReference<T>();
    }

    public static <T extends Closeable> AtomicSharedReference<T> create(T t) {
        return new AtomicSharedReference<T>(t, t);
    }

    public static <T> AtomicSharedReference<T> create(T t, Closeable closeable) {
        return new AtomicSharedReference<T>(t, closeable);
    }

    private AtomicSharedReference() {
        this.ref = null;
    }

    private AtomicSharedReference(T t, Closeable closeable) {
        this.ref = SharedReference.create(t, closeable);
    }

    @Nullable
    public synchronized SharedReference<T> getAndSet(T t) {
        return this.getAndSet(t, (Closeable)t);
    }

    @Nullable
    public synchronized SharedReference<T> getAndSet(T t, Closeable closeable) {
        if (this.ref != null && this.ref.get() == t) {
            return this.ref.copy();
        }
        SharedReference<T> ret = this.ref;
        this.ref = SharedReference.create(t, closeable);
        return ret;
    }

    @Deprecated
    @Nullable
    public SharedReference<T> get() {
        return this.getCopy();
    }

    @Nullable
    public synchronized SharedReference<T> getCopy() {
        if (this.ref == null) {
            return null;
        }
        return this.ref.copy();
    }

    public synchronized void set(T t) throws IOException {
        this.set(t, (Closeable)t);
    }

    public synchronized void setQuietly(T t) {
        if (this.ref != null && this.ref.get() == t) {
            return;
        }
        this.unsetQuietly();
        this.ref = SharedReference.create(t, (Closeable)t);
    }

    public synchronized void set(T t, Closeable closeable) throws IOException {
        if (this.ref != null && this.ref.get() == t) {
            return;
        }
        if (this.ref != null) {
            this.ref.close();
        }
        this.ref = SharedReference.create(t, closeable);
    }

    public synchronized void unset() throws IOException {
        if (this.ref != null) {
            this.ref.close();
        }
        this.ref = null;
    }

    public synchronized void unsetQuietly() {
        if (this.ref != null) {
            Closeables2.closeQuietly(this.ref, log);
        }
        this.ref = null;
    }

    @Nullable
    public synchronized SharedReference<T> getAndUnset() {
        SharedReference<T> ret = this.ref;
        this.ref = null;
        return ret;
    }

    public synchronized int getRefCount() {
        if (this.ref == null) {
            return 0;
        }
        return this.ref.getRefCount();
    }

    @Nullable
    public synchronized <Z> Z map(Function<T, Z> f) {
        if (this.ref == null) {
            return (Z)f.apply(null);
        }
        return (Z)f.apply(this.ref.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <Z> Z mapWithCopy(Function<T, Z> f) throws IOException {
        try (SharedReference<T> localRef = this.getCopy();){
            if (localRef == null) {
                Object object = f.apply(null);
                return (Z)object;
            }
            Object object = f.apply(localRef.get());
            return (Z)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <Z> Z mapWithCopyQuietly(Function<T, Z> function) {
        SharedReference<T> localRef = this.getCopy();
        try {
            if (localRef == null) {
                Object object = function.apply(null);
                return (Z)object;
            }
            Object object = function.apply(localRef.get());
            return (Z)object;
        }
        finally {
            if (localRef != null) {
                Closeables2.closeQuietly(localRef, log);
            }
        }
    }
}

