/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.threads;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ThreadSafeBitSet
implements Serializable {
    private static final long serialVersionUID = -7685178028568216346L;
    private final int[] bits;
    private final int size;

    public ThreadSafeBitSet(int size) {
        this.size = size;
        this.bits = new int[size + 31 >>> 5];
    }

    private ThreadSafeBitSet(int[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    private int finalIntUsedBitMask() {
        int nbUsedBitsInLastInt = this.size % 32;
        int nbUselessBits = (32 - nbUsedBitsInLastInt) % 32;
        return -1 >>> nbUselessBits;
    }

    private void cleanUpLastInt() {
        int nbUsedBitsInLastInt = this.size % 32;
        if (nbUsedBitsInLastInt > 0) {
            int n = this.bits.length - 1;
            this.bits[n] = this.bits[n] & this.finalIntUsedBitMask();
        }
    }

    public final void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public final boolean get(int index) {
        int t = 1 << (index & 0x1F);
        return (this.bits[index >> 5] & t) != 0;
    }

    public ThreadSafeBitSet copy() {
        return new ThreadSafeBitSet((int[])this.bits.clone(), this.size);
    }

    public final int size() {
        return this.size;
    }

    public final void set(int index) {
        int n = index >>> 5;
        this.bits[n] = this.bits[n] | 1 << (index & 0x1F);
    }

    public final void clear(int index) {
        int n = index >>> 5;
        this.bits[n] = this.bits[n] & ~(1 << (index & 0x1F));
    }

    public final void clearAll() {
        Arrays.fill(this.bits, 0);
    }

    public final void setAll() {
        Arrays.fill(this.bits, -1);
        this.cleanUpLastInt();
    }

    public final void invertAll() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = ~this.bits[i];
        }
        this.cleanUpLastInt();
    }

    public final void and(ThreadSafeBitSet other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("BitSets must be of equal size");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & other.bits[i];
        }
    }

    public final void or(ThreadSafeBitSet other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("BitSets must be of equal size");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | other.bits[i];
        }
    }

    public final void xor(ThreadSafeBitSet other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("BitSets must be of equal size");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
        }
    }

    public final void copyFrom(ThreadSafeBitSet other) {
        if (other.size == this.size) {
            System.arraycopy(other.bits, 0, this.bits, 0, other.bits.length);
        } else if (other.size < this.size) {
            if (other.size > 0) {
                int lastInt;
                System.arraycopy(other.bits, 0, this.bits, 0, other.bits.length - 1);
                int otherLastInt = other.bits[other.bits.length - 1];
                int myLastModifiedInt = this.bits[other.bits.length - 1];
                int mask = other.finalIntUsedBitMask();
                this.bits[other.bits.length - 1] = lastInt = mask & otherLastInt | ~mask & myLastModifiedInt;
            }
        } else {
            throw new IllegalArgumentException("Copy from array bigger than destination is forbidden");
        }
    }

    public final void copyFromRange(ThreadSafeBitSet other, int startIndex, int otherStartIndex, int length) {
        if (length == 0) {
            return;
        }
        int endIndex = startIndex + length - 1;
        int otherEndIndex = otherStartIndex + length - 1;
        int bitsStartIndex = startIndex >>> 5;
        int otherBitsStartIndex = otherStartIndex >>> 5;
        int bitsEndIndex = endIndex >>> 5;
        if ((startIndex & 0x1F) == (otherStartIndex & 0x1F)) {
            if (bitsStartIndex != bitsEndIndex) {
                System.arraycopy(other.bits, otherBitsStartIndex + 1, this.bits, bitsStartIndex + 1, bitsEndIndex - bitsStartIndex - 1);
                this.simpleCopyFromRange(other, startIndex, otherStartIndex, 32 - (startIndex & 0x1F));
                this.simpleCopyFromRange(other, endIndex & 0xFFFFFFE0, otherEndIndex & 0xFFFFFFE0, (endIndex & 0x1F) + 1);
            } else {
                this.simpleCopyFromRange(other, startIndex, otherStartIndex, length);
            }
        } else if (bitsStartIndex != bitsEndIndex) {
            int difference = (startIndex & 0x1F) - (otherStartIndex & 0x1F);
            int absDifference = Math.abs(difference);
            int reverseDifference = 32 - absDifference;
            int reverseDifferenceMask = -1 << reverseDifference;
            int absDifferenceMask = -1 << absDifference;
            if (difference > 0) {
                this.bits[bitsStartIndex] = this.bits[bitsStartIndex] & ~(-1 << (startIndex & 0x1F)) | (other.bits[otherBitsStartIndex] & -1 << (otherStartIndex & 0x1F)) << difference;
                int bitsIndex = bitsStartIndex + 1;
                int otherBitsIndex = otherBitsStartIndex;
                while (bitsIndex < bitsEndIndex) {
                    this.bits[bitsIndex] = (other.bits[otherBitsIndex] & reverseDifferenceMask) >>> reverseDifference | (other.bits[otherBitsIndex + 1] & ~reverseDifferenceMask) << difference;
                    ++bitsIndex;
                    ++otherBitsIndex;
                }
                this.simpleCopyFromRange(other, endIndex & 0xFFFFFFE0, otherEndIndex - (endIndex & 0x1F), (endIndex & 0x1F) + 1);
            } else {
                this.simpleCopyFromRange(other, startIndex, otherStartIndex, 32 - (startIndex & 0x1F));
                int bitsIndex = bitsStartIndex + 1;
                int otherBitsIndex = otherBitsStartIndex + 1;
                while (bitsIndex < bitsEndIndex) {
                    this.bits[bitsIndex] = (other.bits[otherBitsIndex] & absDifferenceMask) >>> absDifference | (other.bits[otherBitsIndex + 1] & ~absDifferenceMask) << reverseDifference;
                    ++bitsIndex;
                    ++otherBitsIndex;
                }
                this.simpleCopyFromRange(other, endIndex & 0xFFFFFFE0, otherEndIndex - (endIndex & 0x1F), (endIndex & 0x1F) + 1);
            }
        } else {
            this.simpleCopyFromRange(other, startIndex, otherStartIndex, length);
        }
    }

    private void simpleCopyFromRange(ThreadSafeBitSet other, int startIndex, int otherStartIndex, int length) {
        for (int i = 0; i < length; ++i) {
            this.set(startIndex + i, other.get(otherStartIndex + i));
        }
    }

    public final int cardinality() {
        int sum = 0;
        for (int x : this.bits) {
            sum += Integer.bitCount(x);
        }
        return sum;
    }

    public static ThreadSafeBitSet expand(@Nullable ThreadSafeBitSet oldBitSet, int newSize) {
        if (oldBitSet != null && newSize <= oldBitSet.size) {
            return oldBitSet;
        }
        ThreadSafeBitSet ret = new ThreadSafeBitSet(newSize);
        if (oldBitSet != null) {
            ret.copyFrom(oldBitSet);
        }
        return ret;
    }

    public static boolean equals(ThreadSafeBitSet bitset1, ThreadSafeBitSet bitset2) {
        if (bitset1 == bitset2) {
            return true;
        }
        if (bitset1 == null || bitset2 == null) {
            return false;
        }
        if (bitset1.size() != bitset2.size()) {
            return false;
        }
        return Arrays.equals(bitset1.bits, bitset2.bits);
    }

    public static ThreadSafeBitSet or(ThreadSafeBitSet a, ThreadSafeBitSet b) {
        int i;
        int size = Math.max(a.size(), b.size());
        ThreadSafeBitSet ret = new ThreadSafeBitSet(size);
        for (i = 0; i < a.bits.length; ++i) {
            int n = i;
            ret.bits[n] = ret.bits[n] | a.bits[i];
        }
        for (i = 0; i < b.bits.length; ++i) {
            int n = i;
            ret.bits[n] = ret.bits[n] | b.bits[i];
        }
        return ret;
    }
}

