/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public final class NativeLibraryUtils {
    private static final Logger log = Logger.getLogger(NativeLibraryUtils.class);

    public static void loadLibrary(String name) {
        NativeLibraryUtils.loadLibrary(name, "");
    }

    public static void loadLibrary(String name, String version) {
        try {
            String osName = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            String prefix = NativeLibraryUtils.getLibraryPrefix(osName);
            String extension = NativeLibraryUtils.getLibraryType(osName);
            String libName = prefix + name + "." + extension + (Strings.isNullOrEmpty((String)version) ? "" : "." + version);
            String resourcePath = "/native/" + osName + "-" + arch + "/" + libName;
            InputStream is = NativeLibraryUtils.class.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new FileNotFoundException("unable to find " + libName + " at resource path " + resourcePath);
            }
            File tempFile = File.createTempFile(prefix + name, "." + extension);
            FileOutputStream os = new FileOutputStream(tempFile);
            ByteStreams.copy((InputStream)is, (OutputStream)os);
            ((OutputStream)os).close();
            is.close();
            System.load(tempFile.getAbsolutePath());
            tempFile.delete();
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.warn((Object)("unable to load " + name + " using class loader, looking in java.library.path"), e);
            System.loadLibrary(name);
        }
    }

    static String getLibraryPrefix(String os) {
        if (os.startsWith("Windows")) {
            return "";
        }
        return "lib";
    }

    static String getLibraryType(String os) {
        if (os.startsWith("Linux")) {
            return "so";
        }
        if (os.startsWith("FreeBSD")) {
            return "so";
        }
        if (os.startsWith("Mac OS X")) {
            return "dylib";
        }
        if (os.startsWith("Windows")) {
            return "dll";
        }
        throw new IllegalArgumentException();
    }
}

